/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.Catalog;
import Freeze.CatalogData;
import Freeze.Connection;
import Freeze.DatabaseException;
import Freeze.EvictorElement;
import Freeze.EvictorI;
import Freeze.Index;
import Freeze.NotFoundException;
import Freeze.ObjectRecord;
import Freeze.Transaction;
import Freeze.Util;
import Ice.Communicator;
import Ice.Identity;
import IceInternal.BasicStream;
import IceUtil.Cache;
import IceUtil.Store;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.DeadlockException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.OperationStatus;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

class ObjectStore
implements Store {
    private final Cache _cache = new Cache(this);
    private Database _db;
    private final String _facet;
    private final String _dbName;
    private final EvictorI _evictor;
    private final List _indices;
    private final Communicator _communicator;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ObjectStore(String facet, boolean createDb, EvictorI evictor, List indices, boolean populateEmptyIndices) {
        this._facet = facet;
        this._evictor = evictor;
        this._indices = indices;
        this._communicator = evictor.communicator();
        this._dbName = facet.equals("") ? "$default" : facet;
        Connection connection = Util.createConnection(this._communicator, evictor.dbEnv().getEnvName());
        try {
            Catalog catalog = new Catalog(connection, Util.catalogName(), true);
            CatalogData catalogData = (CatalogData)catalog.get(evictor.filename());
            if (catalogData != null && !catalogData.evictor) {
                DatabaseException ex = new DatabaseException();
                ex.message = this._evictor.errorPrefix() + evictor.filename() + " is not an evictor database";
                throw ex;
            }
            Environment dbEnv = evictor.dbEnv().getEnv();
            try {
                try {
                    Transaction tx = connection.beginTransaction();
                    com.sleepycat.db.Transaction txn = Util.getTxn(tx);
                    DatabaseConfig config = new DatabaseConfig();
                    config.setType(DatabaseType.BTREE);
                    config.setAllowCreate(createDb);
                    this._db = dbEnv.openDatabase(txn, evictor.filename(), this._dbName, config);
                    Iterator p = this._indices.iterator();
                    while (p.hasNext()) {
                        Index index = (Index)p.next();
                        index.associate(this, txn, createDb, populateEmptyIndices);
                    }
                    if (catalogData == null) {
                        catalogData = new CatalogData();
                        catalogData.evictor = true;
                        catalog.put(evictor.filename(), catalogData);
                    }
                    tx.commit();
                }
                catch (FileNotFoundException dx) {
                    NotFoundException ex = new NotFoundException();
                    ex.initCause(dx);
                    ex.message = this._evictor.errorPrefix() + "Db.open: " + dx.getMessage();
                    throw ex;
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = this._evictor.errorPrefix() + "Db.open: " + dx.getMessage();
                    throw ex;
                }
                Object var16_20 = null;
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                Transaction tx2 = connection.currentTransaction();
                if (tx2 == null) throw throwable;
                try {
                    tx2.rollback();
                    throw throwable;
                }
                catch (DatabaseException de) {
                    // empty catch block
                }
                throw throwable;
            }
            Transaction tx2 = connection.currentTransaction();
            if (tx2 == null) return;
            try {}
            catch (DatabaseException de) {}
            tx2.rollback();
            return;
        }
        finally {
            connection.close();
        }
    }

    protected void finalize() {
        if (this._db != null) {
            this.close();
        }
    }

    void close() {
        try {
            this._db.close();
            Iterator p = this._indices.iterator();
            while (p.hasNext()) {
                Index index = (Index)p.next();
                index.close();
            }
            this._indices.clear();
        }
        catch (com.sleepycat.db.DatabaseException dx) {
            DatabaseException ex = new DatabaseException();
            ex.initCause(dx);
            ex.message = this._evictor.errorPrefix() + "Db.close: " + dx.getMessage();
            throw ex;
        }
        this._db = null;
    }

    boolean dbHasObject(Identity ident) {
        byte[] key = ObjectStore.marshalKey(ident, this._communicator);
        DatabaseEntry dbKey = new DatabaseEntry(key);
        DatabaseEntry dbValue = new DatabaseEntry();
        dbValue.setPartial(true);
        while (true) {
            try {
                OperationStatus err = this._db.get(null, dbKey, dbValue, null);
                if (err == OperationStatus.SUCCESS) {
                    return true;
                }
                if (err == OperationStatus.NOTFOUND) {
                    return false;
                }
                throw new DatabaseException();
            }
            catch (DeadlockException dx) {
                if (!this._evictor.deadlockWarning()) continue;
                this._communicator.getLogger().warning("Deadlock in Freeze.ObjectStore.dhHasObject while reading Db \"" + this._evictor.filename() + "/" + this._dbName + "\"; retrying...");
                continue;
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = this._evictor.errorPrefix() + "Db.get: " + dx.getMessage();
                throw ex;
            }
            break;
        }
    }

    void save(byte[] key, byte[] value, byte status, com.sleepycat.db.Transaction tx) throws com.sleepycat.db.DatabaseException {
        switch (status) {
            case 1: 
            case 2: {
                DatabaseEntry dbKey = new DatabaseEntry(key);
                DatabaseEntry dbValue = new DatabaseEntry(value);
                OperationStatus err = status == 1 ? this._db.putNoOverwrite(tx, dbKey, dbValue) : this._db.put(tx, dbKey, dbValue);
                if (err == OperationStatus.SUCCESS) break;
                throw new DatabaseException();
            }
            case 3: {
                DatabaseEntry dbKey = new DatabaseEntry(key);
                OperationStatus err = this._db.delete(tx, dbKey);
                if (err == OperationStatus.SUCCESS) break;
                throw new DatabaseException();
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    static byte[] marshalKey(Identity v, Communicator communicator) {
        BasicStream os = new BasicStream(Ice.Util.getInstance(communicator));
        v.__write(os);
        ByteBuffer buf = os.prepareWrite();
        byte[] r = new byte[buf.limit()];
        buf.get(r);
        return r;
    }

    static Identity unmarshalKey(byte[] b, Communicator communicator) {
        BasicStream is = new BasicStream(Ice.Util.getInstance(communicator));
        is.resize(b.length, true);
        ByteBuffer buf = is.prepareRead();
        buf.position(0);
        buf.put(b);
        buf.position(0);
        Identity key = new Identity();
        key.__read(is);
        return key;
    }

    static byte[] marshalValue(ObjectRecord v, Communicator communicator) {
        BasicStream os = new BasicStream(Ice.Util.getInstance(communicator));
        os.startWriteEncaps();
        v.__write(os);
        os.writePendingObjects();
        os.endWriteEncaps();
        ByteBuffer buf = os.prepareWrite();
        byte[] r = new byte[buf.limit()];
        buf.get(r);
        return r;
    }

    static ObjectRecord unmarshalValue(byte[] b, Communicator communicator) {
        BasicStream is = new BasicStream(Ice.Util.getInstance(communicator));
        is.sliceObjects(false);
        is.resize(b.length, true);
        ByteBuffer buf = is.prepareRead();
        buf.position(0);
        buf.put(b);
        buf.position(0);
        ObjectRecord rec = new ObjectRecord();
        is.startReadEncaps();
        rec.__read(is);
        is.readPendingObjects();
        is.endReadEncaps();
        return rec;
    }

    final Cache cache() {
        return this._cache;
    }

    final Database db() {
        return this._db;
    }

    final Communicator communicator() {
        return this._communicator;
    }

    final EvictorI evictor() {
        return this._evictor;
    }

    final String facet() {
        return this._facet;
    }

    final String dbName() {
        return this._dbName;
    }

    public Object load(Object identObj) {
        Identity ident = (Identity)identObj;
        byte[] key = ObjectStore.marshalKey(ident, this._communicator);
        DatabaseEntry dbKey = new DatabaseEntry(key);
        DatabaseEntry dbValue = new DatabaseEntry();
        while (true) {
            try {
                OperationStatus rs = this._db.get(null, dbKey, dbValue, null);
                if (rs == OperationStatus.NOTFOUND) {
                    return null;
                }
                if (rs != OperationStatus.SUCCESS) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    throw new DatabaseException();
                }
            }
            catch (DeadlockException dx) {
                if (!this._evictor.deadlockWarning()) continue;
                this._communicator.getLogger().warning("Deadlock in Freeze.ObjectStore.load while reading Db \"" + this._evictor.filename() + "/" + this._dbName + "\"; retrying...");
                continue;
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = this._evictor.errorPrefix() + "Db.get: " + dx.getMessage();
                throw ex;
            }
            break;
        }
        EvictorElement result = new EvictorElement(ident, this);
        result.rec = ObjectStore.unmarshalValue(dbValue.getData(), this._communicator);
        this._evictor.initialize(ident, this._facet, result.rec.servant);
        return result;
    }

    static {
        $assertionsDisabled = !ObjectStore.class.desiredAssertionStatus();
    }
}

