// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Aspect_PixMap_HeaderFile
#define _Aspect_PixMap_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Aspect_PixMap_HeaderFile
#include <Handle_Aspect_PixMap.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Aspect_Handle_HeaderFile
#include <Aspect_Handle.hxx>
#endif
class Aspect_PixmapDefinitionError;
class Aspect_PixmapError;


//! This class allows the definition of a pixmap(bitmap) <br>
class Aspect_PixMap : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Destroy the pixmap <br>
Standard_EXPORT virtual  void Destroy()  = 0;

//! Creates the image file <aFilename> from this pixmap <br>
//! with an optional gamma correction value according to the graphic system <br>
//! and returns TRUE if the dump occurs normaly. <br>
//! Warning: only XWD, GIF, BMP formats are supported according <br>
//! to the file extension <br>
Standard_EXPORT virtual  Standard_Boolean Dump(const Standard_CString aFilename,const Standard_Real aGammaValue = 1.0) const = 0;

//! Returns the ID of the just created pixmap <br>
Standard_EXPORT virtual  Aspect_Handle PixmapID() const = 0;

//! Returns the allocated pixmap's size in PIXEL <br>
Standard_EXPORT   void Size(Standard_Integer& aWidth,Standard_Integer& anHeight) const;

//! Returns the allocated pixmap's depth (planes number) <br>
Standard_EXPORT   Standard_Integer Depth() const;
//Standard_EXPORT ~Aspect_PixMap();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Initializes the datas of a pixmap with a pixel size <br>
//! <aWidth,<anHeight> and depth. <br>
Standard_EXPORT Aspect_PixMap(const Standard_Integer aWidth,const Standard_Integer anHeight,const Standard_Integer aDepth);


 // Fields PROTECTED
 //
Standard_Integer myWidth;
Standard_Integer myHeight;
Standard_Integer myDepth;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
