// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOPTools_ShapeShapeInterference_HeaderFile
#define _BOPTools_ShapeShapeInterference_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  Root class for storing  an  Interference <br>
//!  between a couple BRep shapes <br>
class BOPTools_ShapeShapeInterference  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor <br>
Standard_EXPORT BOPTools_ShapeShapeInterference();


//! Constructor <br>
Standard_EXPORT BOPTools_ShapeShapeInterference(const Standard_Integer anIndex1,const Standard_Integer anIndex2);


//! Modifier <br>
//! Sets DS-index for the first shape from the  couple <br>
Standard_EXPORT   void SetIndex1(const Standard_Integer anIndex1) ;


//! Modifier <br>
//! Sets DS-index for the second shape from the  couple <br>
Standard_EXPORT   void SetIndex2(const Standard_Integer anIndex2) ;


//! Modifier <br>
//! Sets DS-index for the new shape <br>
Standard_EXPORT   void SetNewShape(const Standard_Integer anIndex) ;


//! Selector <br>
Standard_EXPORT   Standard_Integer Index1() const;


//! Selector <br>
Standard_EXPORT   Standard_Integer Index2() const;


//! Selector <br>
Standard_EXPORT   void Indices(Standard_Integer& anIndex1,Standard_Integer& anIndex2) const;


//! Selector <br>
//! Gets the value of index <br>
//! if  anIndex==myIndex1 it returns myIndex2; <br>
//! if  anIndex==myIndex2 it returns myIndex1; <br>
//! otherwise it returns 0; <br>
Standard_EXPORT   Standard_Integer OppositeIndex(const Standard_Integer anIndex) const;


//! Selector <br>
Standard_EXPORT   Standard_Integer NewShape() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myIndex1;
Standard_Integer myIndex2;
Standard_Integer myNewShape;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
