// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_ShellSplitter_HeaderFile
#define _BOP_ShellSplitter_HeaderFile

#ifndef _TopoDS_Shell_HeaderFile
#include <TopoDS_Shell.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _BOPTColStd_ListOfListOfShape_HeaderFile
#include <BOPTColStd_ListOfListOfShape.hxx>
#endif
#ifndef _BOP_IndexedDataMapOfEdgeListFaceInfo_HeaderFile
#include <BOP_IndexedDataMapOfEdgeListFaceInfo.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
class TopTools_ListOfShape;
class TopoDS_Shell;
class BOPTColStd_ListOfListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  the algorithm to split (multiconnexed) <br>
//!  shells on a solid onto biconnexed shells <br>
//!  when each edge is shared by only two or one <br>
//!   faces <br>
class BOP_ShellSplitter  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor; <br>
Standard_EXPORT BOP_ShellSplitter();


//! Perform the algorithm using the  list of shapes <aLE> as data <br>
Standard_EXPORT   void DoWithListOfEdges(const TopTools_ListOfShape& aLE) ;


//! Modifier <br>
Standard_EXPORT   void SetShell(const TopoDS_Shell& aShell) ;


//! Selector <br>
Standard_EXPORT  const TopoDS_Shell& Shell() const;


//! Perform the algorithm using the shell as data <br>
Standard_EXPORT   void DoWithShell() ;


//! Returns TRUE if the source shell is valid and <br>
//! there  is  nothing to correct <br>
Standard_EXPORT   Standard_Boolean IsNothingToDo() const;


//! Returns TRUE if the algorithm was performed <br>
//! successfuly <br>
Standard_EXPORT   Standard_Boolean IsDone() const;


//! Selector <br>
Standard_EXPORT  const BOPTColStd_ListOfListOfShape& Shapes() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


//! Perform the algorithm <br>
Standard_EXPORT   void Do() ;


 // Fields PRIVATE
 //
TopoDS_Shell myShell;
Standard_Boolean myIsDone;
Standard_Boolean myNothingToDo;
BOPTColStd_ListOfListOfShape myShapes;
BOP_IndexedDataMapOfEdgeListFaceInfo mySmartMap;
TopTools_ListOfShape myFaces;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
