// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepAlgo_NormalProjection_HeaderFile
#define _BRepAlgo_NormalProjection_HeaderFile

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeListOfShape_HeaderFile
#include <TopTools_DataMapOfShapeListOfShape.hxx>
#endif
class Standard_ConstructionError;
class Standard_NoSuchObject;
class StdFail_NotDone;
class TopoDS_Shape;
class TopoDS_Edge;
class TopTools_ListOfShape;
class Adaptor3d_Curve;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class makes the projection  of a wire on a <br>
//!           shape. <br>
class BRepAlgo_NormalProjection  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepAlgo_NormalProjection();


Standard_EXPORT BRepAlgo_NormalProjection(const TopoDS_Shape& S);


Standard_EXPORT   void Init(const TopoDS_Shape& S) ;

//! Add an edge or a wire to the list of shape to project <br>
//! <br>
Standard_EXPORT   void Add(const TopoDS_Shape& ToProj) ;

//! Set the parameters  used  for computation <br>
//!          Tol3d is the requiered  tolerance between the  3d projected <br>
//!          curve  and its 2d representation <br>
//!          InternalContinuity  is the order of constraints <br>
//!          used for  approximation. <br>
//!          MaxDeg and MaxSeg are the maximum degree and the maximum <br>
//!          number of segment for BSpline resulting of an approximation. <br>
Standard_EXPORT   void SetParams(const Standard_Real Tol3D,const Standard_Real Tol2D,const GeomAbs_Shape InternalContinuity,const Standard_Integer MaxDegree,const Standard_Integer MaxSeg) ;

//! Set the parameters  used  for computation <br>
//!          in their default values <br>
Standard_EXPORT   void SetDefaultParams() ;

//!  Sets the maximum distance between target shape and <br>
//!  shape to project. If this condition is not satisfied then <br>
//!  corresponding part of solution is discarded. <br>
//!  if MaxDist < 0 then this method does not affect the algorithm <br>
Standard_EXPORT   void SetMaxDistance(const Standard_Real MaxDist) ;

//!  if  With3d = Standard_False the 3dcurve is not computed <br>
//! the  initial 3dcurve is kept  to  build the  resulting edges. <br>
Standard_EXPORT   void Compute3d(const Standard_Boolean With3d = Standard_True) ;

//!  Manage  limitation  of  projected  edges. <br>
Standard_EXPORT   void SetLimit(const Standard_Boolean FaceBoundaries = Standard_True) ;

//! Builds the result as a  compound. <br>
Standard_EXPORT   void Build() ;


Standard_EXPORT   Standard_Boolean IsDone() const;

//! returns the result <br>
Standard_EXPORT  const TopoDS_Shape& Projection() const;

//! For a resulting edge, returns the corresponding initial edge. <br>
Standard_EXPORT  const TopoDS_Shape& Ancestor(const TopoDS_Edge& E) const;

//! For a projected edge, returns the corresponding initial face. <br>
Standard_EXPORT  const TopoDS_Shape& Couple(const TopoDS_Edge& E) const;

//! Returns the  list   of shapes generated   from the <br>
//!          shape <S>. <br>
Standard_EXPORT  const TopTools_ListOfShape& Generated(const TopoDS_Shape& S) ;


Standard_EXPORT   Standard_Boolean IsElementary(const Adaptor3d_Curve& C) const;

//! build the result as a list of wire if possible in -- <br>
//!  a first returns a wire only if there is only a wire. <br>
//! <br>
Standard_EXPORT   Standard_Boolean BuildWire(TopTools_ListOfShape& Liste) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Shape myShape;
Standard_Boolean myIsDone;
Standard_Real myTol3d;
Standard_Real myTol2d;
Standard_Real myMaxDist;
Standard_Boolean myWith3d;
GeomAbs_Shape myContinuity;
Standard_Integer myMaxDegree;
Standard_Integer myMaxSeg;
Standard_Boolean myFaceBounds;
TopoDS_Shape myToProj;
TopTools_DataMapOfShapeShape myAncestorMap;
TopTools_DataMapOfShapeShape myCorresp;
TopTools_DataMapOfShapeListOfShape myDescendants;
TopoDS_Shape myRes;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
