// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepLib_MakeShell_HeaderFile
#define _BRepLib_MakeShell_HeaderFile

#ifndef _BRepLib_ShellError_HeaderFile
#include <BRepLib_ShellError.hxx>
#endif
#ifndef _BRepLib_MakeShape_HeaderFile
#include <BRepLib_MakeShape.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class StdFail_NotDone;
class Geom_Surface;
class TopoDS_Shell;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides methos to build shells. <br>
//! <br>
//!          Build a shell from a set of faces. <br>
//!          Build a shell from a non C2 surface. <br>
class BRepLib_MakeShell  : public BRepLib_MakeShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Not done. <br>
Standard_EXPORT BRepLib_MakeShell();


Standard_EXPORT BRepLib_MakeShell(const Handle(Geom_Surface)& S,const Standard_Boolean Segment = Standard_False);


Standard_EXPORT BRepLib_MakeShell(const Handle(Geom_Surface)& S,const Standard_Real UMin,const Standard_Real UMax,const Standard_Real VMin,const Standard_Real VMax,const Standard_Boolean Segment = Standard_False);

//! Creates the shell from the surface  and the min-max <br>
//!          values. <br>
Standard_EXPORT   void Init(const Handle(Geom_Surface)& S,const Standard_Real UMin,const Standard_Real UMax,const Standard_Real VMin,const Standard_Real VMax,const Standard_Boolean Segment = Standard_False) ;


Standard_EXPORT   BRepLib_ShellError Error() const;

//! Returns the new Shell. <br>
//! <br>
Standard_EXPORT  const TopoDS_Shell& Shell() const;
Standard_EXPORT operator TopoDS_Shell() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepLib_ShellError myError;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
