// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepPrimAPI_MakeRevolution_HeaderFile
#define _BRepPrimAPI_MakeRevolution_HeaderFile

#ifndef _BRepPrim_Revolution_HeaderFile
#include <BRepPrim_Revolution.hxx>
#endif
#ifndef _BRepPrimAPI_MakeOneAxis_HeaderFile
#include <BRepPrimAPI_MakeOneAxis.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
class Standard_DomainError;
class Geom_Curve;
class gp_Ax2;
class BRepPrim_Revolution;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions to build revolved shapes. <br>
//! A MakeRevolution object provides a framework for: <br>
//! -   defining the construction of a revolved shape, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the result. <br>
class BRepPrimAPI_MakeRevolution  : public BRepPrimAPI_MakeOneAxis {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Make a revolution body by rotating a curve around Z. <br>
Standard_EXPORT BRepPrimAPI_MakeRevolution(const Handle(Geom_Curve)& Meridian);

//! Make a revolution body by rotating a curve around Z. <br>
Standard_EXPORT BRepPrimAPI_MakeRevolution(const Handle(Geom_Curve)& Meridian,const Standard_Real angle);

//! Make a revolution body by rotating a curve around Z. <br>
Standard_EXPORT BRepPrimAPI_MakeRevolution(const Handle(Geom_Curve)& Meridian,const Standard_Real VMin,const Standard_Real VMax);

//! Make a revolution body by rotating a curve around Z. <br>
Standard_EXPORT BRepPrimAPI_MakeRevolution(const Handle(Geom_Curve)& Meridian,const Standard_Real VMin,const Standard_Real VMax,const Standard_Real angle);

//! Make a revolution body by rotating a curve around Z. <br>
Standard_EXPORT BRepPrimAPI_MakeRevolution(const gp_Ax2& Axes,const Handle(Geom_Curve)& Meridian);

//! Make a revolution body by rotating a curve around Z. <br>
Standard_EXPORT BRepPrimAPI_MakeRevolution(const gp_Ax2& Axes,const Handle(Geom_Curve)& Meridian,const Standard_Real angle);

//! Make a revolution body by rotating a curve around Z. <br>
Standard_EXPORT BRepPrimAPI_MakeRevolution(const gp_Ax2& Axes,const Handle(Geom_Curve)& Meridian,const Standard_Real VMin,const Standard_Real VMax);

//! Make a revolution body by rotating a curve around Z. <br>//! For all algorithms the resulting shape is composed of <br>
//! -   a lateral revolved face, <br>
//! -   two planar faces in planes parallel to the plane z = <br>
//!   0, and passing by the extremities of the revolved <br>
//!   portion of Meridian, if these points are not on the Z <br>
//!   axis (in case of a complete revolved shape, these faces are circles), <br>
//! -   and in the case of a portion of a revolved shape, two <br>
//!   planar faces to close the shape (in the planes u = 0 and u = angle). <br>
Standard_EXPORT BRepPrimAPI_MakeRevolution(const gp_Ax2& Axes,const Handle(Geom_Curve)& Meridian,const Standard_Real VMin,const Standard_Real VMax,const Standard_Real angle);

//! Returns the algorithm. <br>
Standard_EXPORT   Standard_Address OneAxis() ;

//! Returns the algorithm. <br>
//! <br>
Standard_EXPORT   BRepPrim_Revolution& Revolution() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepPrim_Revolution myRevolution;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
