// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepSweep_Prism_HeaderFile
#define _BRepSweep_Prism_HeaderFile

#ifndef _BRepSweep_Translation_HeaderFile
#include <BRepSweep_Translation.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_ConstructionError;
class TopoDS_Shape;
class gp_Vec;
class gp_Dir;
class Sweep_NumShape;
class TopLoc_Location;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides natural constructors to build BRepSweep <br>
//!          translated swept Primitives. <br>
class BRepSweep_Prism  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Builds the prism of base S and vector V. If C is true, <br>
//!          S is copied. If Canonize is true then generated surfaces <br>
//!          are attempted to be canonized in simple types <br>
Standard_EXPORT BRepSweep_Prism(const TopoDS_Shape& S,const gp_Vec& V,const Standard_Boolean Copy = Standard_False,const Standard_Boolean Canonize = Standard_True);

//! Builds a semi-infinite or an infinite prism of base S. <br>
//!          If Copy is true S is copied.  If Inf is true the prism <br>
//!          is infinite, if Inf is false the  prism is infinite in <br>
//!          the direction D. If Canonize is true then generated surfaces <br>
//!          are attempted to be canonized in simple types <br>
Standard_EXPORT BRepSweep_Prism(const TopoDS_Shape& S,const gp_Dir& D,const Standard_Boolean Inf = Standard_True,const Standard_Boolean Copy = Standard_False,const Standard_Boolean Canonize = Standard_True);

//! Returns the TopoDS Shape attached to the prism. <br>
Standard_EXPORT   TopoDS_Shape Shape() ;

//! Returns    the  TopoDS  Shape   generated  with  aGenS <br>
//!          (subShape  of the generating shape). <br>
Standard_EXPORT   TopoDS_Shape Shape(const TopoDS_Shape& aGenS) ;

//! Returns the  TopoDS  Shape of the bottom of the prism. <br>
Standard_EXPORT   TopoDS_Shape FirstShape() ;

//! Returns the TopoDS Shape of the bottom  of the  prism. <br>
//!          generated  with  aGenS  (subShape  of  the  generating <br>
//!          shape). <br>
Standard_EXPORT   TopoDS_Shape FirstShape(const TopoDS_Shape& aGenS) ;

//! Returns the TopoDS Shape of the top of the prism. <br>
Standard_EXPORT   TopoDS_Shape LastShape() ;

//! Returns the  TopoDS  Shape of the top  of  the  prism. <br>
//!          generated  with  aGenS  (subShape  of  the  generating <br>
//!          shape). <br>
Standard_EXPORT   TopoDS_Shape LastShape(const TopoDS_Shape& aGenS) ;

//! Returns the Vector of the Prism,  if it is an infinite <br>
//!          prism the Vec is unitar. <br>
Standard_EXPORT   gp_Vec Vec() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! used to build the NumShape of a limited prism. <br>
Standard_EXPORT   Sweep_NumShape NumShape() const;

//! used to build the NumShape of an infinite prism. <br>
Standard_EXPORT   Sweep_NumShape NumShape(const Standard_Boolean Inf) const;

//! used to build the Location. <br>
Standard_EXPORT   TopLoc_Location Location(const gp_Vec& V) const;


 // Fields PRIVATE
 //
BRepSweep_Translation myTranslation;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
