// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Convert_ConeToBSplineSurface_HeaderFile
#define _Convert_ConeToBSplineSurface_HeaderFile

#ifndef _Convert_ElementarySurfaceToBSplineSurface_HeaderFile
#include <Convert_ElementarySurfaceToBSplineSurface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_DomainError;
class gp_Cone;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  This algorithm converts a bounded Cone into a rational <br>
//!  B-spline  surface. <br>
//!  The cone a Cone from package gp. Its parametrization is : <br>
//!  P (U, V) =  Loc + V * Zdir + <br>
//!              (R + V*Tan(Ang)) * (Cos(U)*Xdir + Sin(U)*Ydir) <br>
//!  where Loc is the location point of the cone, Xdir, Ydir and Zdir <br>
//!  are the normalized directions of the local cartesian coordinate <br>
//!  system of the cone (Zdir is the direction of the Cone's axis) , <br>
//!  Ang is the cone semi-angle.  The U parametrization range is <br>
//!  [0, 2PI]. <br>
//! KeyWords : <br>
//!  Convert, Cone, BSplineSurface. <br>
class Convert_ConeToBSplineSurface  : public Convert_ElementarySurfaceToBSplineSurface {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//!  The equivalent B-spline surface as the same orientation as the <br>
//!  Cone in the U and V parametric directions. <br>
//!  Raised if U1 = U2 or U1 = U2 + 2.0 * Pi <br>
//!  Raised if V1 = V2. <br>
Standard_EXPORT Convert_ConeToBSplineSurface(const gp_Cone& C,const Standard_Real U1,const Standard_Real U2,const Standard_Real V1,const Standard_Real V2);


//!  The equivalent B-spline surface as the same orientation as the <br>
//!  Cone in the U and V parametric directions. <br>
//!  Raised if V1 = V2. <br>
Standard_EXPORT Convert_ConeToBSplineSurface(const gp_Cone& C,const Standard_Real V1,const Standard_Real V2);





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
