// File generated by CPPExt (Enum)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Convert_ParameterisationType_HeaderFile
#define _Convert_ParameterisationType_HeaderFile


//! Identifies a type of parameterization of a circle or ellipse represented as a BSpline curve. <br>
//! For a circle with a center C and a radius R (for example a Geom2d_Circle or a Geom_Circle), <br>
//! the natural parameterization is angular. It uses the angle Theta made by the vector CM with <br>
//! the 'X Axis' of the circle's local coordinate system as parameter for the current point M. The <br>
//! coordinates of the point M are as follows: <br>
//!     X   =   R *cos ( Theta ) <br>
//!     y   =   R * sin ( Theta ) <br>
//!   Similarly, for an ellipse with a center C, a major radius R and a minor radius r, the circle Circ <br>
//! with center C and radius R (and located in the same plane as the ellipse) lends its natural <br>
//! angular parameterization to the ellipse. This is achieved by an affine transformation in the plane <br>
//! of the ellipse, in the ratio r / R, about the 'X Axis' of its local coordinate system. The <br>
//! coordinates of the current point M are as follows: <br>
//!     X   =   R * cos ( Theta ) <br>
//!     y   =   r * sin ( Theta ) <br>
//! The process of converting a circle or an ellipse into a rational or non-rational BSpline curve <br>
//! transforms the Theta angular parameter into a parameter t. This ensures the rational or <br>
//! polynomial parameterization of the resulting BSpline curve. Several types of parametric <br>
//! transformations are available. <br>
//! TgtThetaOver2 <br>
//! The most usual method is Convert_TgtThetaOver2 where the parameter t on the BSpline <br>
//! curve is obtained by means of transformation of the following type: <br>
//!  t = tan ( Theta / 2 ) <br>
//! The result of this definition is: <br>
//!  cos ( Theta ) = ( 1. - t**2 ) / ( 1. + t**2 ) <br>
//!  sin ( Theta ) =      2. * t / ( 1. + t**2 ) <br>
//! which ensures the rational parameterization of the circle or the ellipse. However, this is not the <br>
//! most suitable parameterization method where the arc of the circle or ellipse has a large opening <br>
//! angle. In such cases, the curve will be represented by a BSpline with intermediate knots. Each <br>
//! span, i.e. each portion of curve between two different knot values, will use parameterization of <br>
//! this type. <br>
//! The number of spans is calculated using the following rule: <br>
//!     ( 1.2 * Delta / Pi ) + 1 <br>
//! where Delta is equal to the opening angle (in radians) of the arc of the circle (Delta is <br>
//! equal to 2.* Pi in the case of a complete circle). <br>
//! The resulting BSpline curve is "exact", i.e. computing any point of parameter t on the BSpline <br>
//! curve gives an exact point on the circle or the ellipse. <br>
//! TgtThetaOver2_N <br>
//! Where N is equal to 1, 2, 3 or 4, this ensures the same type of parameterization as <br>
//! Convert_TgtThetaOver2 but sets the number of spans in the resulting BSpline curve to N <br>
//! rather than allowing the algorithm to make this calculation. <br>
//! However, the opening angle Delta (parametric angle, given in radians) of the arc of the circle <br>
//! (or of the ellipse) must comply with the following: <br>
//! -   Delta <= 0.9999 * Pi for the Convert_TgtThetaOver2_1 method, or <br>
//! -   Delta <= 1.9999 * Pi for the Convert_TgtThetaOver2_2 method. <br>
//! QuasiAngular <br>
//! The Convert_QuasiAngular method of parameterization uses a different type of rational <br>
//! parameterization. This method ensures that the parameter t along the resulting BSpline curve is <br>
//! very close to the natural parameterization angle Theta of the circle or ellipse (i.e. which uses <br>
//! the functions sin ( Theta ) and cos ( Theta ). <br>
//! The resulting BSpline curve is "exact", i.e. computing any point of parameter t on the BSpline <br>
//! curve gives an exact point on the circle or the ellipse. <br>
//! RationalC1 <br>
//! The Convert_RationalC1 method of parameterization uses a further type of rational <br>
//! parameterization. This method ensures that the equation relating to the resulting BSpline curve <br>
//! has a "C1" continuous denominator, which is not the case with the above methods. RationalC1 <br>
//! enhances the degree of continuity at the junction point of the different spans of the curve. <br>
//! The resulting BSpline curve is "exact", i.e. computing any point of parameter t on the BSpline <br>
//! curve gives an exact point on the circle or the ellipse. <br>
//! Polynomial <br>
//! The Convert_Polynomial method is used to produce polynomial (i.e. non-rational) <br>
//! parameterization of the resulting BSpline curve with 8 poles (i.e. a polynomial degree equal to 7). <br>
//! However, the result is an approximation of the circle or ellipse (i.e. computing the point of <br>
//! parameter t on the BSpline curve does not give an exact point on the circle or the ellipse). <br>
enum Convert_ParameterisationType { 
 Convert_TgtThetaOver2,
Convert_TgtThetaOver2_1,
Convert_TgtThetaOver2_2,
Convert_TgtThetaOver2_3,
Convert_TgtThetaOver2_4,
Convert_QuasiAngular,
Convert_RationalC1,
Convert_Polynomial
};


#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif

#endif
