// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Expr_GeneralFunction_HeaderFile
#define _Expr_GeneralFunction_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Expr_GeneralFunction_HeaderFile
#include <Handle_Expr_GeneralFunction.hxx>
#endif

#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Expr_NamedUnknown_HeaderFile
#include <Handle_Expr_NamedUnknown.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_OutOfRange;
class Standard_DimensionMismatch;
class Standard_NumericError;
class Expr_NotEvaluable;
class Expr_NamedUnknown;
class Expr_Array1OfNamedUnknown;
class TColStd_Array1OfReal;
class TCollection_AsciiString;


//! Defines the general purposes of any function. <br>
class Expr_GeneralFunction : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Returns the number of variables of <me>. <br>
Standard_EXPORT virtual  Standard_Integer NbOfVariables() const = 0;

//! Returns the variable denoted by <index> in <me>. <br>
//!          Raises OutOfRange if index > NbOfVariables. <br>
Standard_EXPORT virtual  Handle_Expr_NamedUnknown Variable(const Standard_Integer index) const = 0;

//! Returns a copy of <me> with the same form. <br>
Standard_EXPORT virtual  Handle_Expr_GeneralFunction Copy() const = 0;

//! Returns Derivative of <me> for variable <var>. <br>
Standard_EXPORT virtual  Handle_Expr_GeneralFunction Derivative(const Handle(Expr_NamedUnknown)& var) const = 0;

//! Returns Derivative of <me> for variable <var> with <br>
//!          degree <deg>. <br>
Standard_EXPORT virtual  Handle_Expr_GeneralFunction Derivative(const Handle(Expr_NamedUnknown)& var,const Standard_Integer deg) const = 0;

//! Computes the value of <me> with the given variables. <br>
//!          Raises NotEvaluable if <vars> does not match all variables <br>
//!          of <me>. <br>
Standard_EXPORT virtual  Standard_Real Evaluate(const Expr_Array1OfNamedUnknown& vars,const TColStd_Array1OfReal& vals) const = 0;

//! Tests if <me> and <func> are similar functions (same <br>
//!          name and same used expression). <br>
Standard_EXPORT virtual  Standard_Boolean IsIdentical(const Handle(Expr_GeneralFunction)& func) const = 0;

//! Tests if <me> is linear on variable on range <index> <br>
Standard_EXPORT virtual  Standard_Boolean IsLinearOnVariable(const Standard_Integer index) const = 0;


Standard_EXPORT virtual  TCollection_AsciiString GetStringName() const = 0;
//Standard_EXPORT ~Expr_GeneralFunction();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
