// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Expr_GeneralRelation_HeaderFile
#define _Expr_GeneralRelation_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Expr_GeneralRelation_HeaderFile
#include <Handle_Expr_GeneralRelation.hxx>
#endif

#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Expr_GeneralExpression_HeaderFile
#include <Handle_Expr_GeneralExpression.hxx>
#endif
#ifndef _Handle_Expr_NamedUnknown_HeaderFile
#include <Handle_Expr_NamedUnknown.hxx>
#endif
class Standard_OutOfRange;
class Standard_NumericError;
class Expr_GeneralExpression;
class Expr_NamedUnknown;
class TCollection_AsciiString;


//! Defines the general purposes of any relation between <br>
//!          expressions. <br>
class Expr_GeneralRelation : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Returns the current status of the relation <br>
Standard_EXPORT virtual  Standard_Boolean IsSatisfied() const = 0;

//! Tests if <me> is linear between its NamedUnknowns. <br>
Standard_EXPORT virtual  Standard_Boolean IsLinear() const = 0;

//! Returns a GeneralRelation after replacement of <br>
//!          NamedUnknowns by an associated expression, and after <br>
//!          values computation. <br>
Standard_EXPORT virtual  Handle_Expr_GeneralRelation Simplified() const = 0;

//! Replaces NamedUnknowns by associated expressions, <br>
//!          and computes values in <me>. <br>
Standard_EXPORT virtual  void Simplify()  = 0;

//! Returns a copy of <me> having the same unknowns and <br>
//!          functions. <br>
Standard_EXPORT virtual  Handle_Expr_GeneralRelation Copy() const = 0;

//! Returns the number of relations contained in <me>. <br>
Standard_EXPORT virtual  Standard_Integer NbOfSubRelations() const = 0;

//! Returns the number of SingleRelations contained in <br>
//!          <me>. <br>
Standard_EXPORT virtual  Standard_Integer NbOfSingleRelations() const = 0;

//! Returns the relation denoted by <index> in <me>. <br>
//!          An exception is raised if <index> is out of range. <br>
Standard_EXPORT virtual  Handle_Expr_GeneralRelation SubRelation(const Standard_Integer index) const = 0;

//! Tests if <exp> contains <var>. <br>
Standard_EXPORT virtual  Standard_Boolean Contains(const Handle(Expr_GeneralExpression)& exp) const = 0;

//! Replaces all occurences of <var> with <with> in <me>. <br>
Standard_EXPORT virtual  void Replace(const Handle(Expr_NamedUnknown)& var,const Handle(Expr_GeneralExpression)& with)  = 0;

//! returns a string representing <me> in a readable way. <br>
Standard_EXPORT virtual  TCollection_AsciiString String() const = 0;
//Standard_EXPORT ~Expr_GeneralRelation();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
