// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Expr_SystemRelation_HeaderFile
#define _Expr_SystemRelation_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Expr_SystemRelation_HeaderFile
#include <Handle_Expr_SystemRelation.hxx>
#endif

#ifndef _Expr_SequenceOfGeneralRelation_HeaderFile
#include <Expr_SequenceOfGeneralRelation.hxx>
#endif
#ifndef _Expr_GeneralRelation_HeaderFile
#include <Expr_GeneralRelation.hxx>
#endif
#ifndef _Handle_Expr_GeneralRelation_HeaderFile
#include <Handle_Expr_GeneralRelation.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Expr_GeneralExpression_HeaderFile
#include <Handle_Expr_GeneralExpression.hxx>
#endif
#ifndef _Handle_Expr_NamedUnknown_HeaderFile
#include <Handle_Expr_NamedUnknown.hxx>
#endif
class Standard_OutOfRange;
class Standard_NoSuchObject;
class Standard_DimensionMismatch;
class Standard_NumericError;
class Expr_GeneralRelation;
class Expr_GeneralExpression;
class Expr_NamedUnknown;
class TCollection_AsciiString;



class Expr_SystemRelation : public Expr_GeneralRelation {

public:
 // Methods PUBLIC
 // 

//! Creates a system with one relation <br>
Standard_EXPORT Expr_SystemRelation(const Handle(Expr_GeneralRelation)& relation);

//! Appends <relation> in the list of components of <me>. <br>
Standard_EXPORT   void Add(const Handle(Expr_GeneralRelation)& relation) ;


Standard_EXPORT   void Remove(const Handle(Expr_GeneralRelation)& relation) ;

//! Tests if <me> is linear between its NamedUnknowns. <br>
Standard_EXPORT   Standard_Boolean IsLinear() const;

//! Returns the number of relations contained in <me>. <br>
Standard_EXPORT   Standard_Integer NbOfSubRelations() const;

//! Returns the number of SingleRelations contained in <br>
//!          <me>. <br>
Standard_EXPORT   Standard_Integer NbOfSingleRelations() const;

//! Returns the relation denoted by <index> in <me>. <br>
//!          An exception is raised if <index> is out of range. <br>
Standard_EXPORT   Handle_Expr_GeneralRelation SubRelation(const Standard_Integer index) const;


Standard_EXPORT   Standard_Boolean IsSatisfied() const;

//! Returns a GeneralRelation after replacement of <br>
//!          NamedUnknowns by an associated expression, and after <br>
//!          values computation. <br>
Standard_EXPORT   Handle_Expr_GeneralRelation Simplified() const;

//! Replaces NamedUnknowns by associated expressions, <br>
//!          and computes values in <me>. <br>
Standard_EXPORT   void Simplify() ;

//! Returns a copy of <me> having the same unknowns and functions. <br>
Standard_EXPORT   Handle_Expr_GeneralRelation Copy() const;

//! Tests if <me> contains <exp>. <br>
Standard_EXPORT   Standard_Boolean Contains(const Handle(Expr_GeneralExpression)& exp) const;

//! Replaces all occurences of <var> with <with> in <me>. <br>
Standard_EXPORT   void Replace(const Handle(Expr_NamedUnknown)& var,const Handle(Expr_GeneralExpression)& with) ;

//! returns a string representing <me> in a readable way. <br>
Standard_EXPORT   TCollection_AsciiString String() const;
//Standard_EXPORT ~Expr_SystemRelation();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Expr_SequenceOfGeneralRelation myRelations;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
