// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GCPnts_AbscissaPoint_HeaderFile
#define _GCPnts_AbscissaPoint_HeaderFile

#ifndef _CPnts_AbscissaPoint_HeaderFile
#include <CPnts_AbscissaPoint.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class StdFail_NotDone;
class Standard_ConstructionError;
class Adaptor3d_Curve;
class Adaptor2d_Curve2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides an algorithm to compute a point on a curve <br>
//! situated at a given distance from another point on the <br>
//! curve, the distance being measured along the curve <br>
//! (curvilinear abscissa on the curve). <br>
//! This algorithm is also used to compute the length of a curve. <br>
//! An AbscissaPoint object provides a framework for: <br>
//! -   defining the point to compute <br>
//! -   implementing the construction algorithm <br>
//! -   consulting the result. <br>
class GCPnts_AbscissaPoint  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Computes the length of the Curve <C>. <br>
Standard_EXPORT static  Standard_Real Length(Adaptor3d_Curve& C) ;

//! Computes the length of the Curve <C>. <br>
Standard_EXPORT static  Standard_Real Length(Adaptor2d_Curve2d& C) ;

//! Computes the length of the Curve <C> with the given tolerance. <br>
Standard_EXPORT static  Standard_Real Length(Adaptor3d_Curve& C,const Standard_Real Tol) ;

//! Computes the length of the Curve <C> with the given tolerance. <br>
Standard_EXPORT static  Standard_Real Length(Adaptor2d_Curve2d& C,const Standard_Real Tol) ;

//! Computes the length of the Curve <C>. <br>
Standard_EXPORT static  Standard_Real Length(Adaptor3d_Curve& C,const Standard_Real U1,const Standard_Real U2) ;

//! Computes the length of the Curve <C>. <br>
Standard_EXPORT static  Standard_Real Length(Adaptor2d_Curve2d& C,const Standard_Real U1,const Standard_Real U2) ;

//! Computes the length of the Curve <C> with the given tolerance. <br>
Standard_EXPORT static  Standard_Real Length(Adaptor3d_Curve& C,const Standard_Real U1,const Standard_Real U2,const Standard_Real Tol) ;

//! Computes the length of the Curve <C> with the given tolerance. <br>//! Constructs an empty algorithm. This function is used <br>
//! only for initializing a framework to compute the length <br>
//! of a curve (or a series of curves). <br>
//! Warning <br>
//! The function IsDone will return the value false after the use of this function. <br>
Standard_EXPORT static  Standard_Real Length(Adaptor2d_Curve2d& C,const Standard_Real U1,const Standard_Real U2,const Standard_Real Tol) ;


Standard_EXPORT GCPnts_AbscissaPoint();

//! the algorithm computes a point on a curve <Curve> at the <br>
//!          distance <Abscissa> from the point of parameter <U0>. <br>
Standard_EXPORT GCPnts_AbscissaPoint(Adaptor3d_Curve& C,const Standard_Real Abscissa,const Standard_Real U0);

//! the  algorithm computes a point on  a curve <Curve> at <br>
//!           the distance  <Abscissa> from the  point of parameter <br>
//!          <U0> with the given  tolerance. <br>
Standard_EXPORT GCPnts_AbscissaPoint(const Standard_Real Tol,Adaptor3d_Curve& C,const Standard_Real Abscissa,const Standard_Real U0);

//! the  algorithm computes a point on  a curve <Curve> at <br>
//!           the distance  <Abscissa> from the  point of parameter <br>
//!          <U0> with the given  tolerance. <br>
Standard_EXPORT GCPnts_AbscissaPoint(const Standard_Real Tol,Adaptor2d_Curve2d& C,const Standard_Real Abscissa,const Standard_Real U0);

//! the algorithm computes a point on a curve <Curve> at the <br>
//!          distance <Abscissa> from the point of parameter <U0>. <br>
Standard_EXPORT GCPnts_AbscissaPoint(Adaptor2d_Curve2d& C,const Standard_Real Abscissa,const Standard_Real U0);

//! the algorithm computes a point on a curve <Curve> at the <br>
//!          distance <Abscissa> from the point of parameter <U0>. <br>
//!          <Ui> is the starting value used in the iterative process <br>
//!          which find the solution, it must be close to the final <br>
//!          solution <br>
Standard_EXPORT GCPnts_AbscissaPoint(Adaptor3d_Curve& C,const Standard_Real Abscissa,const Standard_Real U0,const Standard_Real Ui);

//! the algorithm computes a point on a curve <Curve> at the <br>
//!          distance <Abscissa> from the point of parameter <U0>. <br>
//!          <Ui> is the starting value used in the iterative process <br>
//!          which find the solution, it must be closed to the final <br>
//!          solution <br>
Standard_EXPORT GCPnts_AbscissaPoint(Adaptor2d_Curve2d& C,const Standard_Real Abscissa,const Standard_Real U0,const Standard_Real Ui);

//! the algorithm computes a point on a curve <Curve> at the <br>
//!          distance <Abscissa> from the point of parameter <U0>. <br>
//!          <Ui> is the starting value used in the iterative process <br>
//!          which find the solution, it must be close to the final <br>
//!          solution <br>
Standard_EXPORT GCPnts_AbscissaPoint(Adaptor3d_Curve& C,const Standard_Real Abscissa,const Standard_Real U0,const Standard_Real Ui,const Standard_Real Tol);

//! the algorithm computes a point on a curve <Curve> at the <br>
//!          distance <Abscissa> from the point of parameter <U0>. <br>
//!          <Ui> is the starting value used in the iterative process <br>
//!          which find the solution, it must be close to the final <br>
//!          solution <br>
Standard_EXPORT GCPnts_AbscissaPoint(Adaptor2d_Curve2d& C,const Standard_Real Abscissa,const Standard_Real U0,const Standard_Real Ui,const Standard_Real Tol);
//! True if the computation was successful, False otherwise. <br>
//!   IsDone is a protection against: <br>
//! -   non-convergence of the algorithm <br>
//! -   querying the results before computation. <br>
  Standard_Boolean IsDone() const;
//! Returns the parameter on the curve of the point <br>
//! solution of this algorithm. <br>
//! Exceptions <br>
//! StdFail_NotDone if the computation was not <br>
//! successful, or was not done. <br>
  Standard_Real Parameter() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
CPnts_AbscissaPoint myComputer;


};


#include <GCPnts_AbscissaPoint.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
