// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomAPI_HeaderFile
#define _GeomAPI_HeaderFile

#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
class Geom2d_Curve;
class Geom_Curve;
class gp_Pln;
class GeomAPI_ProjectPointOnCurve;
class GeomAPI_ProjectPointOnSurf;
class GeomAPI_ExtremaCurveCurve;
class GeomAPI_ExtremaCurveSurface;
class GeomAPI_ExtremaSurfaceSurface;
class GeomAPI_PointsToBSpline;
class GeomAPI_PointsToBSplineSurface;
class GeomAPI_Interpolate;
class GeomAPI_IntSS;
class GeomAPI_IntCS;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The   GeomAPI   package  provides  an  Application <br>
//!          Programming Interface for the Geometry. <br>
//! <br>
//!          The API is a set of  classes and methods aiming to <br>
//!          provide : <br>
//! <br>
//!          * High level and simple calls  for the most common <br>
//!          operations. <br>
//! <br>
//!          *    Keeping   an   access  on    the    low-level <br>
//!          implementation of high-level calls. <br>
//! <br>
//! <br>
//! 	    The API  provides classes to  call the algorithmes <br>
//! 	    of the Geometry <br>
//! <br>
//! 	    * The  constructors  of the classes  provides  the <br>
//! 	    different constructions methods. <br>
//! <br>
//! 	    * The  class keeps as fields the   different tools <br>
//! 	    used by the algorithmes <br>
//! <br>
//! 	    *   The class  provides  a  casting  method to get <br>
//! 	    automatically the  result  with  a   function-like <br>
//! 	    call. <br>
//! <br>
//! 	    For example to evaluate the distance <D> between a <br>
//! 	    point <P> and a curve <C>, one can writes : <br>
//! <br>
//! 	        D = GeomAPI_ProjectPointOnCurve(P,C); <br>
//! <br>
//! 	    or <br>
//! <br>
//! 	        GeomAPI_ProjectPointOnCurve PonC(P,C); <br>
//! 	        D = PonC.LowerDistance(); <br>
//! <br>
class GeomAPI  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! This function builds (in the <br>
//! parametric space of the plane P) a 2D curve equivalent to the 3D curve <br>
//! C. The 3D curve C is considered to be located in the plane P. <br>
//! Warning <br>
//! The 3D curve C must be of one of the following types: <br>
//! -      a line <br>
//! -      a circle <br>
//! -      an ellipse <br>
//! -      a hyperbola <br>
//! -      a parabola <br>
//! -      a Bezier curve <br>
//! -      a BSpline curve <br>
//! Exceptions Standard_NoSuchObject if C is not a defined type curve. <br>
Standard_EXPORT static  Handle_Geom2d_Curve To2d(const Handle(Geom_Curve)& C,const gp_Pln& P) ;

//! Builds a 3D curve equivalent to the 2D curve C <br>
//! described in the parametric space defined by the local <br>
//! coordinate system of plane P. <br>
//! The resulting 3D curve is of the same nature as that of the curve C. <br>
Standard_EXPORT static  Handle_Geom_Curve To3d(const Handle(Geom2d_Curve)& C,const gp_Pln& P) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class GeomAPI_ProjectPointOnCurve;
friend class GeomAPI_ProjectPointOnSurf;
friend class GeomAPI_ExtremaCurveCurve;
friend class GeomAPI_ExtremaCurveSurface;
friend class GeomAPI_ExtremaSurfaceSurface;
friend class GeomAPI_PointsToBSpline;
friend class GeomAPI_PointsToBSplineSurface;
friend class GeomAPI_Interpolate;
friend class GeomAPI_IntSS;
friend class GeomAPI_IntCS;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
