// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomLib_Check2dBSplineCurve_HeaderFile
#define _GeomLib_Check2dBSplineCurve_HeaderFile

#ifndef _Handle_Geom2d_BSplineCurve_HeaderFile
#include <Handle_Geom2d_BSplineCurve.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Pnt2d_HeaderFile
#include <gp_Pnt2d.hxx>
#endif
class Geom2d_BSplineCurve;
class StdFail_NotDone;
class Standard_OutOfRange;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! this class is used to  construct the BSpline curve <br>
//!          from an Approximation ( ApproxAFunction from AdvApprox). <br>
class GeomLib_Check2dBSplineCurve  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT GeomLib_Check2dBSplineCurve(const Handle(Geom2d_BSplineCurve)& Curve,const Standard_Real Tolerance,const Standard_Real AngularTolerance);

  Standard_Boolean IsDone() const;


Standard_EXPORT   void NeedTangentFix(Standard_Boolean& FirstFlag,Standard_Boolean& SecondFlag) const;


Standard_EXPORT   void FixTangent(const Standard_Boolean FirstFlag,const Standard_Boolean LastFlag) ;

//!  modifies the curve <br>
//! by fixing the first or the last tangencies <br>
//! <br>//! if Index3D not in the Range [1,Nb3dSpaces] <br>//! if the Approx is not Done <br>
Standard_EXPORT   Handle_Geom2d_BSplineCurve FixedTangent(const Standard_Boolean FirstFlag,const Standard_Boolean LastFlag) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom2d_BSplineCurve myCurve;
Standard_Boolean myDone;
Standard_Boolean myFixFirstTangent;
Standard_Boolean myFixLastTangent;
Standard_Real myAngularTolerance;
Standard_Real myTolerance;
gp_Pnt2d myFirstPole;
gp_Pnt2d myLastPole;


};


#include <GeomLib_Check2dBSplineCurve.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
