// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom_Curve_HeaderFile
#define _Geom_Curve_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif

#ifndef _Geom_Geometry_HeaderFile
#include <Geom_Geometry.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_RangeError;
class Standard_NoSuchObject;
class Geom_UndefinedDerivative;
class Geom_UndefinedValue;
class gp_Trsf;
class gp_Pnt;
class gp_Vec;


//! The abstract class Curve describes the common <br>
//! behavior of curves in 3D space. The Geom package <br>
//! provides numerous concrete classes of derived <br>
//! curves, including lines, circles, conics, Bezier or <br>
//! BSpline curves, etc. <br>
//! The main characteristic of these curves is that they <br>
//! are parameterized. The Geom_Curve class shows: <br>
//! - how to work with the parametric equation of a curve <br>
//!   in order to calculate the point of parameter u, <br>
//!   together with the vector tangent and the derivative <br>
//!   vectors of order 2, 3,..., N at this point; <br>
//! - how to obtain general information about the curve <br>
//!   (for example, level of continuity, closed <br>
//!   characteristics, periodicity, bounds of the parameter field); <br>
//! - how the parameter changes when a geometric <br>
//!   transformation is applied to the curve or when the <br>
//!   orientation of the curve is inverted. <br>
//!   All curves must have a geometric continuity: a curve is <br>
//!   at least "C0". Generally, this property is checked at <br>
//! the time of construction or when the curve is edited. <br>
//! Where this is not the case, the documentation states so explicitly. <br>
//! Warning <br>
//! The Geom package does not prevent the <br>
//! construction of curves with null length or curves which <br>
//! self-intersect. <br>
class Geom_Curve : public Geom_Geometry {

public:
 // Methods PUBLIC
 // 


//!  Changes the direction of parametrization of <me>. <br>
//!  The "FirstParameter" and the "LastParameter" are not changed <br>
//!  but the orientation  of the curve is modified. If the curve <br>
//!  is bounded the StartPoint of the initial curve becomes the <br>
//!  EndPoint of the reversed curve  and the EndPoint of the initial <br>
//!  curve becomes the StartPoint of the reversed curve. <br>
Standard_EXPORT virtual  void Reverse()  = 0;

//! Returns the  parameter on the  reversed  curve for <br>
//!          the point of parameter U on <me>. <br>
//! <br>
//!          me->Reversed()->Value(me->ReversedParameter(U)) <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          me->Value(U) <br>
Standard_EXPORT virtual  Standard_Real ReversedParameter(const Standard_Real U) const = 0;

//! Returns the  parameter on the  transformed  curve for <br>
//!          the transform of the point of parameter U on <me>. <br>
//! <br>
//!          me->Transformed(T)->Value(me->TransformedParameter(U,T)) <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          me->Value(U).Transformed(T) <br>
//! <br>
//!          This methods returns <U> <br>
//! <br>
//!          It can be redefined. For example on the Line. <br>
Standard_EXPORT virtual  Standard_Real TransformedParameter(const Standard_Real U,const gp_Trsf& T) const;

//! Returns a  coefficient to compute the parameter on <br>
//!          the transformed  curve  for  the transform  of the <br>
//!          point on <me>. <br>
//! <br>
//!          Transformed(T)->Value(U * ParametricTransformation(T)) <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          Value(U).Transformed(T) <br>
//! <br>
//!          This methods returns 1. <br>
//! <br>
//!          It can be redefined. For example on the Line. <br>
Standard_EXPORT virtual  Standard_Real ParametricTransformation(const gp_Trsf& T) const;

//! Returns a copy of <me> reversed. <br>
Standard_EXPORT   Handle_Geom_Curve Reversed() const;

//! Returns the value of the first parameter. <br>
//!  Warnings : <br>
//!  It can be RealFirst from package Standard <br>
//!  if the curve is infinite <br>
Standard_EXPORT virtual  Standard_Real FirstParameter() const = 0;

//!  Returns the value of the last parameter. <br>
//!  Warnings : <br>
//!  It can be RealLast from package Standard <br>
//!  if the curve is infinite <br>
Standard_EXPORT virtual  Standard_Real LastParameter() const = 0;

//! Returns true if the curve is closed. <br>
//!  Some curves such as circle are always closed, others such as line <br>
//!  are never closed (by definition). <br>
//!  Some Curves such as OffsetCurve can be closed or not. These curves <br>
//!  are considered as closed if the distance between the first point <br>
//!  and the last point of the curve is lower or equal to the Resolution <br>
//!  from package gp wich is a fixed criterion independant of the <br>
//!  application. <br>
Standard_EXPORT virtual  Standard_Boolean IsClosed() const = 0;

//! Is the parametrization of the curve periodic ? <br>
//!  It is possible only if the curve is closed and if the <br>
//!  following relation is satisfied : <br>
//!  for each parametric value U the distance between the point <br>
//!  P(u) and the point P (u + T) is lower or equal to Resolution <br>
//!  from package gp, T is the period and must be a constant. <br>
//!  There are three possibilities : <br>
//!   . the curve is never periodic by definition (SegmentLine) <br>
//!   . the curve is always periodic by definition (Circle) <br>
//!   . the curve can be defined as periodic (BSpline). In this case <br>
//!     a function SetPeriodic allows you to give the shape of the <br>
//!     curve.  The general rule for this case is : if a curve can be <br>
//!     periodic or not the default periodicity set is non periodic <br>
//!     and you have to turn (explicitly) the curve into a periodic <br>
//!     curve  if you want the curve to be periodic. <br>
Standard_EXPORT virtual  Standard_Boolean IsPeriodic() const = 0;

//! Returns the period of this curve. <br>
//! Exceptions Standard_NoSuchObject if this curve is not periodic. <br>
Standard_EXPORT virtual  Standard_Real Period() const;

//! It is the global continuity of the curve <br>
//!  C0 : only geometric continuity, <br>
//!  C1 : continuity of the first derivative all along the Curve, <br>
//!  C2 : continuity of the second derivative all along the Curve, <br>
//!  C3 : continuity of the third derivative all along the Curve, <br>
//!  G1 : tangency continuity all along the Curve, <br>
//!  G2 : curvature continuity all along the Curve, <br>
//!  CN : the order of continuity is infinite. <br>
Standard_EXPORT virtual  GeomAbs_Shape Continuity() const = 0;

//! Returns true if the degree of continuity of this curve is at least N. <br>
//! Exceptions -  Standard_RangeError if N is less than 0. <br>
Standard_EXPORT virtual  Standard_Boolean IsCN(const Standard_Integer N) const = 0;

//! Returns in P the point of parameter U. <br>
//!  If the curve is periodic  then the returned point is P(U) with <br>
//!  U = Ustart + (U - Uend)  where Ustart and Uend are the <br>
//!  parametric bounds of the curve. <br>
//!  Raised only for the "OffsetCurve" if it is not possible to <br>
//!  compute the current point. For example when the first <br>
//!  derivative on the basis curve and the offset direction <br>
//!  are parallel. <br>
Standard_EXPORT virtual  void D0(const Standard_Real U,gp_Pnt& P) const = 0;


//!  Returns the point P of parameter U and the first derivative V1. <br>//! Raised if the continuity of the curve is not C1. <br>
Standard_EXPORT virtual  void D1(const Standard_Real U,gp_Pnt& P,gp_Vec& V1) const = 0;


//!  Returns the point P of parameter U, the first and second <br>
//!  derivatives V1 and V2. <br>//! Raised if the continuity of the curve is not C2. <br>
Standard_EXPORT virtual  void D2(const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2) const = 0;


//!  Returns the point P of parameter U, the first, the second <br>
//!  and the third derivative. <br>//! Raised if the continuity of the curve is not C3. <br>
Standard_EXPORT virtual  void D3(const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2,gp_Vec& V3) const = 0;


//! The returned vector gives the value of the derivative for the <br>
//!  order of derivation N. <br>//! Raised if the continuity of the curve is not CN. <br>
//! <br>//!  Raised if the   derivative  cannot  be  computed <br>
//!         easily. e.g. rational bspline and n > 3. <br>//! Raised if N < 1. <br>
Standard_EXPORT virtual  gp_Vec DN(const Standard_Real U,const Standard_Integer N) const = 0;

//! Computes the point of parameter U on <me>. <br>
//!  If the curve is periodic  then the returned point is P(U) with <br>
//!  U = Ustart + (U - Uend)  where Ustart and Uend are the <br>
//!  parametric bounds of the curve. <br>
//!  it is implemented with D0. <br>
//!  Raised only for the "OffsetCurve" if it is not possible to <br>
//!  compute the current point. For example when the first <br>
//!  derivative on the basis curve and the offset direction are parallel. <br>
Standard_EXPORT   gp_Pnt Value(const Standard_Real U) const;
//Standard_EXPORT ~Geom_Curve();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
