// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom_SurfaceOfLinearExtrusion_HeaderFile
#define _Geom_SurfaceOfLinearExtrusion_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom_SurfaceOfLinearExtrusion_HeaderFile
#include <Handle_Geom_SurfaceOfLinearExtrusion.hxx>
#endif

#ifndef _Geom_SweptSurface_HeaderFile
#include <Geom_SweptSurface.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom_Geometry_HeaderFile
#include <Handle_Geom_Geometry.hxx>
#endif
class Standard_RangeError;
class Geom_UndefinedDerivative;
class Geom_Curve;
class gp_Dir;
class gp_Pnt;
class gp_Vec;
class gp_Trsf;
class gp_GTrsf2d;
class Geom_Geometry;


//! Describes a surface of linear extrusion ("extruded <br>
//! surface"), e.g. a generalized cylinder. Such a surface <br>
//! is obtained by sweeping a curve (called the "extruded <br>
//! curve" or "basis") in a given direction (referred to as <br>
//! the "direction of extrusion" and defined by a unit vector). <br>
//! The u parameter is along the extruded curve. The v <br>
//! parameter is along the direction of extrusion. <br>
//! The parameter range for the u parameter is defined <br>
//! by the reference curve. <br>
//! The parameter range for the v parameter is ] - <br>
//! infinity, + infinity [. <br>
//! The position of the curve gives the origin of the v parameter. <br>
//! The surface is "CN" in the v parametric direction. <br>
//! The form of a surface of linear extrusion is generally a <br>
//! ruled surface (GeomAbs_RuledForm). It can be: <br>
//! - a cylindrical surface, if the extruded curve is a circle, <br>
//!   or a trimmed circle, with an axis parallel to the <br>
//!   direction of extrusion (GeomAbs_CylindricalForm), or <br>
//! - a planar surface, if the extruded curve is a line <br>
//!   (GeomAbs_PlanarForm). <br>
//! Note: The surface of extrusion is built from a copy of <br>
//! the original basis curve, so the original curve is not <br>
//! modified when the surface is modified. <br>
//! Warning <br>
//! Degenerate surfaces are not detected. A degenerate <br>
//! surface is obtained, for example, when the extruded <br>
//! curve is a line and the direction of extrusion is parallel <br>
//! to that line. <br>
class Geom_SurfaceOfLinearExtrusion : public Geom_SweptSurface {

public:
 // Methods PUBLIC
 // 


//!  V is the direction of extrusion. <br>
//!  C is the extruded curve. <br>
//!  The form of a SurfaceOfLinearExtrusion can be : <br>
//!  . ruled surface (RuledForm), <br>
//!  . a cylindrical surface if the extruded curve is a circle or <br>
//!    a trimmed circle (CylindricalForm), <br>
//!  . a plane surface if the extruded curve is a Line (PlanarForm). <br>
//!  Warnings : <br>
//!  Degenerated surface cases are not detected. For example if the <br>
//!  curve C is a line and V is parallel to the direction of this <br>
//!  line. <br>
Standard_EXPORT Geom_SurfaceOfLinearExtrusion(const Handle(Geom_Curve)& C,const gp_Dir& V);

//! Assigns V as the "direction of extrusion" for this <br>
//! surface of linear extrusion. <br>
Standard_EXPORT   void SetDirection(const gp_Dir& V) ;

//! Modifies this surface of linear extrusion by redefining <br>
//! its "basis curve" (the "extruded curve"). <br>
Standard_EXPORT   void SetBasisCurve(const Handle(Geom_Curve)& C) ;

//!  Changes the orientation of this surface of linear <br>
//! extrusion in the u  parametric direction. The <br>
//! bounds of the surface are not changed, but the given <br>
//! parametric direction is reversed. Hence the <br>
//! orientation of the surface is reversed. <br>
//! In the case of a surface of linear extrusion: <br>
//! - UReverse reverses the basis curve, and <br>
//! - VReverse reverses the direction of linear extrusion. <br>
Standard_EXPORT   void UReverse() ;

//! Computes the u parameter on the modified <br>
//! surface, produced by reversing its u  parametric <br>
//! direction, for any point of u parameter U  on this surface of linear extrusion. <br>
//! In the case of an extruded surface: <br>
//! - UReverseParameter returns the reversed <br>
//!   parameter given by the function <br>
//!   ReversedParameter called with U on the basis   curve, <br>
Standard_EXPORT   Standard_Real UReversedParameter(const Standard_Real U) const;

//! Changes the orientation of this surface of linear <br>
//! extrusion in the v parametric direction. The <br>
//! bounds of the surface are not changed, but the given <br>
//! parametric direction is reversed. Hence the <br>
//! orientation of the surface is reversed. <br>
//! In the case of a surface of linear extrusion: <br>
//! - UReverse reverses the basis curve, and <br>
//! - VReverse reverses the direction of linear extrusion. <br>
Standard_EXPORT   void VReverse() ;

//! Computes the v parameter on the modified <br>
//! surface, produced by reversing its u v parametric <br>
//! direction, for any point of v parameter V on this surface of linear extrusion. <br>
//! In the case of an extruded surface VReverse returns -V. <br>
Standard_EXPORT   Standard_Real VReversedParameter(const Standard_Real V) const;

//! Returns the parametric bounds U1, U2, V1 and V2 of <br>
//! this surface of linear extrusion. <br>
//! A surface of linear extrusion is infinite in the v <br>
//! parametric direction, so: <br>
//!     - V1 = Standard_Real::RealFirst() <br>
//! - V2 = Standard_Real::RealLast(). <br>
Standard_EXPORT   void Bounds(Standard_Real& U1,Standard_Real& U2,Standard_Real& V1,Standard_Real& V2) const;

//!  IsUClosed returns true if the "basis curve" of this <br>
//! surface of linear extrusion is closed. <br>
Standard_EXPORT   Standard_Boolean IsUClosed() const;

//! IsVClosed always returns false. <br>
Standard_EXPORT   Standard_Boolean IsVClosed() const;

//! IsCNu returns true if the degree of continuity for the <br>
//! "basis curve" of this surface of linear extrusion is at least N. <br>
//!  Raises RangeError if N < 0. <br>
Standard_EXPORT   Standard_Boolean IsCNu(const Standard_Integer N) const;

//! IsCNv always returns true. <br>
Standard_EXPORT   Standard_Boolean IsCNv(const Standard_Integer N) const;

//! IsUPeriodic returns true if the "basis curve" of this <br>
//! surface of linear extrusion is periodic. <br>
Standard_EXPORT   Standard_Boolean IsUPeriodic() const;

//! IsVPeriodic always returns false. <br>
Standard_EXPORT   Standard_Boolean IsVPeriodic() const;

//! Computes the U isoparametric curve of this surface <br>
//! of linear extrusion. This is the line parallel to the <br>
//! direction of extrusion, passing through the point of <br>
//! parameter U of the basis curve. <br>
Standard_EXPORT   Handle_Geom_Curve UIso(const Standard_Real U) const;

//! Computes the V isoparametric curve of this surface <br>
//! of linear extrusion. This curve is obtained by <br>
//! translating the extruded curve in the direction of <br>
//! extrusion, with the magnitude V. <br>
Standard_EXPORT   Handle_Geom_Curve VIso(const Standard_Real V) const;


//!  Computes the  point P (U, V) on the surface. <br>
//!  The parameter U is the parameter on the extruded curve. <br>
//!  The parametrization V is a linear parametrization, and <br>
//!  the direction of parametrization is the direction of <br>
//!  extrusion. If the point is on the extruded curve, V = 0.0 <br>
Standard_EXPORT   void D0(const Standard_Real U,const Standard_Real V,gp_Pnt& P) const;


//!  Computes the current point and the first derivatives in the <br>
//!  directions U and V. <br>
//!  Raises UndefinedDerivative if the continuity of the surface is not C1. <br>
Standard_EXPORT   void D1(const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V) const;

//!--- Purpose ; <br>
//!  Computes the current point, the first and the second derivatives <br>
//!  in the directions U and V. <br>
//!  Raises UndefinedDerivative if the continuity of the surface is not C2. <br>
Standard_EXPORT   void D2(const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V,gp_Vec& D2U,gp_Vec& D2V,gp_Vec& D2UV) const;


//!  Computes the current point, the first,the second and the third <br>
//!  derivatives in the directions U and V. <br>
//!  Raises UndefinedDerivative if the continuity of the surface is not C3. <br>
Standard_EXPORT   void D3(const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V,gp_Vec& D2U,gp_Vec& D2V,gp_Vec& D2UV,gp_Vec& D3U,gp_Vec& D3V,gp_Vec& D3UUV,gp_Vec& D3UVV) const;


//!  Computes the derivative of order Nu in the direction u <br>
//!  and Nv in the direction v. <br>
//!  Raises UndefinedDerivative if the continuity of the surface is not CNu in the u <br>
//!  direction and CNv in the v direction. <br>
//! Raises RangeError if Nu + Nv < 1 or Nu < 0 or Nv < 0. <br>
Standard_EXPORT   gp_Vec DN(const Standard_Real U,const Standard_Real V,const Standard_Integer Nu,const Standard_Integer Nv) const;

//! The following  functions  evaluates the  local <br>
//! derivatives on surface. Useful to manage discontinuities <br>
//! on the surface. <br>
//!           if    Side  =  1  ->  P  =  S( U+,V ) <br>
//!           if    Side  = -1  ->  P  =  S( U-,V ) <br>
//!           else  P  is betveen discontinuities <br>
//!           can be evaluated using methods  of <br>
//!           global evaluations    P  =  S( U ,V ) <br>
Standard_EXPORT   void LocalD0(const Standard_Real U,const Standard_Real V,const Standard_Integer USide,gp_Pnt& P) const;


Standard_EXPORT   void LocalD1(const Standard_Real U,const Standard_Real V,const Standard_Integer USide,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V) const;


Standard_EXPORT   void LocalD2(const Standard_Real U,const Standard_Real V,const Standard_Integer USide,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V,gp_Vec& D2U,gp_Vec& D2V,gp_Vec& D2UV) const;


Standard_EXPORT   void LocalD3(const Standard_Real U,const Standard_Real V,const Standard_Integer USide,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V,gp_Vec& D2U,gp_Vec& D2V,gp_Vec& D2UV,gp_Vec& D3U,gp_Vec& D3V,gp_Vec& D3UUV,gp_Vec& D3UVV) const;


Standard_EXPORT   gp_Vec LocalDN(const Standard_Real U,const Standard_Real V,const Standard_Integer USide,const Standard_Integer Nu,const Standard_Integer Nv) const;

//! Applies the transformation T to this surface of linear extrusion. <br>
Standard_EXPORT   void Transform(const gp_Trsf& T) ;

//! Computes the  parameters on the  transformed  surface for <br>
//!          the transform of the point of parameters U,V on <me>. <br>
//! <br>
//!          me->Transformed(T)->Value(U',V') <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          me->Value(U,V).Transformed(T) <br>
//! <br>
//!          Where U',V' are the new values of U,V after calling <br>
//! <br>
//!          me->TranformParameters(U,V,T) <br>
//! <br>
//!          This methods multiplies : <br>
//!          U by BasisCurve()->ParametricTransformation(T) <br>
//!          V by T.ScaleFactor() <br>
Standard_EXPORT virtual  void TransformParameters(Standard_Real& U,Standard_Real& V,const gp_Trsf& T) const;

//! Returns a 2d transformation  used to find the  new <br>
//!          parameters of a point on the transformed surface. <br>
//! <br>
//!          me->Transformed(T)->Value(U',V') <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          me->Value(U,V).Transformed(T) <br>
//! <br>
//!          Where U',V' are  obtained by transforming U,V with <br>
//!          th 2d transformation returned by <br>
//! <br>
//!          me->ParametricTransformation(T) <br>
//! <br>
//!          This  methods  returns  a scale <br>
//!          U by BasisCurve()->ParametricTransformation(T) <br>
//!          V by T.ScaleFactor() <br>
Standard_EXPORT virtual  gp_GTrsf2d ParametricTransformation(const gp_Trsf& T) const;

//! Creates a new object which is a copy of this surface of linear extrusion. <br>
Standard_EXPORT   Handle_Geom_Geometry Copy() const;
//Standard_EXPORT ~Geom_SurfaceOfLinearExtrusion();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
