// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic2d_Circle_HeaderFile
#define _Graphic2d_Circle_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Graphic2d_Circle_HeaderFile
#include <Handle_Graphic2d_Circle.hxx>
#endif

#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Graphic2d_Line_HeaderFile
#include <Graphic2d_Line.hxx>
#endif
#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Handle_Graphic2d_Drawer_HeaderFile
#include <Handle_Graphic2d_Drawer.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Aspect_FStream_HeaderFile
#include <Aspect_FStream.hxx>
#endif
#ifndef _Aspect_IFStream_HeaderFile
#include <Aspect_IFStream.hxx>
#endif
class Graphic2d_CircleDefinitionError;
class Graphic2d_GraphicObject;
class Graphic2d_Drawer;


//! Constructs a primitive Circle <br>
class Graphic2d_Circle : public Graphic2d_Line {

public:
 // Methods PUBLIC
 // 

//! Creates a complete circle. <br>
//!	    The center is <X>, <Y>. <br>
//!	    The radius is <Radius>. <br>
//!  Warning: Raises CircleDefinitionError if the <br>
//!          radius is null. <br>
Standard_EXPORT Graphic2d_Circle(const Handle(Graphic2d_GraphicObject)& aGraphicObject,const Quantity_Length X,const Quantity_Length Y,const Quantity_Length Radius);

//! Creates an arc. <br>
//!	    The center is <X>, <Y>. <br>
//!	    The radius is <Radius>. <br>
//!	    Angles are measured counterclockwise with 0 radian <br>
//!	    at 3 o'clock. <br>
//!  Warning: Raises CircleDefinitionError if the <br>
//!          radius is null. <br>
Standard_EXPORT Graphic2d_Circle(const Handle(Graphic2d_GraphicObject)& aGraphicObject,const Quantity_Length X,const Quantity_Length Y,const Quantity_Length Radius,const Quantity_PlaneAngle Alpha,const Quantity_PlaneAngle Beta);

//! returns the coordinates of center of the circle <br>
Standard_EXPORT   void Center(Quantity_Length& X,Quantity_Length& Y) const;

//! returns the radius of this circle <br>
Standard_EXPORT   Quantity_Length Radius() const;

//! returns the first angle of the arc <br>
Standard_EXPORT   Quantity_PlaneAngle FirstAngle() const;

//! returns the second angle of the arc <br>
Standard_EXPORT   Quantity_PlaneAngle SecondAngle() const;

//! defines the coordinates of center of the circle <br>
Standard_EXPORT   void SetCenter(const Quantity_Length X,const Quantity_Length Y) ;

//! defines the radius of this circle <br>
Standard_EXPORT   void SetRadius(const Quantity_Length theR) ;

//! defines the angles of the arc <br>
Standard_EXPORT   void SetAngles(const Quantity_PlaneAngle Alpha,const Quantity_PlaneAngle Beta) ;


Standard_EXPORT virtual  void Save(Aspect_FStream& aFStream) const;


Standard_EXPORT static  void Retrieve(Aspect_IFStream& anIFStream,const Handle(Graphic2d_GraphicObject)& aGraphicObject) ;
//Standard_EXPORT ~Graphic2d_Circle();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Draws the circle <me>. <br>
Standard_EXPORT   void Draw(const Handle(Graphic2d_Drawer)& aDrawer) ;

//! Draws element <anIndex> of the circle <me>. <br>
Standard_EXPORT virtual  void DrawElement(const Handle(Graphic2d_Drawer)& aDrawer,const Standard_Integer anIndex) ;

//! Draws vertex <anIndex> of the circle <me>. <br>
Standard_EXPORT virtual  void DrawVertex(const Handle(Graphic2d_Drawer)& aDrawer,const Standard_Integer anIndex) ;

//! Returns Standard_True if the circle <me> is picked, <br>
//!	    Standard_False if not. <br>
Standard_EXPORT   Standard_Boolean Pick(const Standard_ShortReal X,const Standard_ShortReal Y,const Standard_ShortReal aPrecision,const Handle(Graphic2d_Drawer)& aDrawer) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void DoMinMax() ;


 // Fields PRIVATE
 //
Standard_ShortReal myX;
Standard_ShortReal myY;
Standard_ShortReal myRadius;
Standard_ShortReal myFirstAngle;
Standard_ShortReal mySecondAngle;
Standard_Boolean myisArc;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
