// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _HLRAlgo_Coincidence_HeaderFile
#define _HLRAlgo_Coincidence_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The Coincidence class is used in an Inteference to <br>
//!          store informations on the "hiding" edge. <br>
//! <br>
//!          2D  Data : The  tangent  and the  curvature of the <br>
//!          projection of the edge  at the intersection point. <br>
//!          This is necesserary  when the intersection  is  at <br>
//!          the extremity of the edge. <br>
//! <br>
//!          3D   Data  :  The   state of  the   edge  near the <br>
//!          intersection   with  the face (before  and after). <br>
//!          This is necessary  when the  intersection is  "ON" <br>
//!          the face. <br>
class HLRAlgo_Coincidence  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT HLRAlgo_Coincidence();

  void Set2D(const Standard_Integer FE,const Standard_Real Param) ;

  void SetState3D(const TopAbs_State stbef,const TopAbs_State staft) ;

  void Value2D(Standard_Integer& FE,Standard_Real& Param) const;

  void State3D(TopAbs_State& stbef,TopAbs_State& staft) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myFE;
Standard_Real myParam;
TopAbs_State myStBef;
TopAbs_State myStAft;


};


#include <HLRAlgo_Coincidence.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
