// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESAppli_NodalDisplAndRot_HeaderFile
#define _IGESAppli_NodalDisplAndRot_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESAppli_NodalDisplAndRot_HeaderFile
#include <Handle_IGESAppli_NodalDisplAndRot.hxx>
#endif

#ifndef _Handle_IGESDimen_HArray1OfGeneralNote_HeaderFile
#include <Handle_IGESDimen_HArray1OfGeneralNote.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_IGESAppli_HArray1OfNode_HeaderFile
#include <Handle_IGESAppli_HArray1OfNode.hxx>
#endif
#ifndef _Handle_IGESBasic_HArray1OfHArray1OfXYZ_HeaderFile
#include <Handle_IGESBasic_HArray1OfHArray1OfXYZ.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_IGESDimen_GeneralNote_HeaderFile
#include <Handle_IGESDimen_GeneralNote.hxx>
#endif
#ifndef _Handle_IGESAppli_Node_HeaderFile
#include <Handle_IGESAppli_Node.hxx>
#endif
class IGESDimen_HArray1OfGeneralNote;
class TColStd_HArray1OfInteger;
class IGESAppli_HArray1OfNode;
class IGESBasic_HArray1OfHArray1OfXYZ;
class Standard_DimensionMismatch;
class Standard_OutOfRange;
class IGESDimen_GeneralNote;
class IGESAppli_Node;
class gp_XYZ;


//! defines NodalDisplAndRot, Type <138> Form <0> <br>
//!          in package IGESAppli <br>
//!          Used to communicate finite element post processing <br>
//!          data. <br>
class IGESAppli_NodalDisplAndRot : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESAppli_NodalDisplAndRot();

//! This method is used to set the fields of the class <br>
//!           NodalDisplAndRot <br>
//!       - allNotes       : Used to store the general note describing <br>
//!                          the analysis cases <br>
//!       - allIdentifiers : Used to store the node number <br>
//!                          identifier for the nodes <br>
//!       - allNodes       : Used to store the nodes <br>
//!       - allRotParams   : Used to store the rotation for the nodes <br>
//!       - allTransParams : Used to store the incremental <br>
//!                          displacements for the nodes <br>
//! raises exception if Lengths of allIdentifiers, allNodes, <br>
//! allRotParams, and allTransParams are not same <br>
//! or if length of allNotes and size of each element of allRotParams <br>
//! and allTransParam are not same <br>
Standard_EXPORT   void Init(const Handle(IGESDimen_HArray1OfGeneralNote)& allNotes,const Handle(TColStd_HArray1OfInteger)& allIdentifiers,const Handle(IGESAppli_HArray1OfNode)& allNodes,const Handle(IGESBasic_HArray1OfHArray1OfXYZ)& allRotParams,const Handle(IGESBasic_HArray1OfHArray1OfXYZ)& allTransParams) ;

//! returns the number of analysis cases <br>
Standard_EXPORT   Standard_Integer NbCases() const;

//! returns the number of nodes <br>
Standard_EXPORT   Standard_Integer NbNodes() const;

//! returns the General Note that describes the Index analysis case <br>
//! raises exception if Index <= 0 or Index > NbCases <br>
Standard_EXPORT   Handle_IGESDimen_GeneralNote Note(const Standard_Integer Index) const;

//! returns the node identifier as specified by the Index <br>
//! raises exception if Index <= 0 or Index > NbNodes <br>
Standard_EXPORT   Standard_Integer NodeIdentifier(const Standard_Integer Index) const;

//! returns the node as specified by the Index <br>
//! raises exception if Index <= 0 or Index > NbNodes <br>
Standard_EXPORT   Handle_IGESAppli_Node Node(const Standard_Integer Index) const;

//! returns the Translational Parameters for the particular Index <br>
//! Exception raised if NodeNum <= 0 or NodeNum > NbNodes() <br>
//! or CaseNum <= 0 or CaseNum > NbCases() <br>
Standard_EXPORT   gp_XYZ TranslationParameter(const Standard_Integer NodeNum,const Standard_Integer CaseNum) const;

//! returns the Rotational Parameters for Index <br>
//! Exception raised if NodeNum <= 0 or NodeNum > NbNodes() <br>
//! or CaseNum <= 0 or CaseNum > NbCases() <br>
Standard_EXPORT   gp_XYZ RotationalParameter(const Standard_Integer NodeNum,const Standard_Integer CaseNum) const;
//Standard_EXPORT ~IGESAppli_NodalDisplAndRot();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IGESDimen_HArray1OfGeneralNote theNotes;
Handle_TColStd_HArray1OfInteger theNodeIdentifiers;
Handle_IGESAppli_HArray1OfNode theNodes;
Handle_IGESBasic_HArray1OfHArray1OfXYZ theTransParam;
Handle_IGESBasic_HArray1OfHArray1OfXYZ theRotParam;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
