// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESData_Protocol_HeaderFile
#define _IGESData_Protocol_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESData_Protocol_HeaderFile
#include <Handle_IGESData_Protocol.hxx>
#endif

#ifndef _Interface_Protocol_HeaderFile
#include <Interface_Protocol.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Handle_Standard_Type_HeaderFile
#include <Handle_Standard_Type.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
class Interface_Protocol;
class Standard_Type;
class Interface_InterfaceModel;
class Standard_Transient;


//! Description of basic Protocol for IGES <br>
//!           This comprises treatement of IGESModel and Recognition of <br>
//!           Undefined-FreeFormat-Entity <br>
class IGESData_Protocol : public Interface_Protocol {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESData_Protocol();

//! Gives the count of Resource Protocol. Here, none <br>
Standard_EXPORT   Standard_Integer NbResources() const;

//! Returns a Resource, given a rank. Here, none <br>
Standard_EXPORT   Handle_Interface_Protocol Resource(const Standard_Integer num) const;

//! Returns a Case Number, specific of each recognized Type <br>
//!         Here, Undefined and Free Format Entities have the Number 1. <br>
Standard_EXPORT   Standard_Integer TypeNumber(const Handle(Standard_Type)& atype) const;

//! Creates an empty Model for IGES Norm <br>
Standard_EXPORT   Handle_Interface_InterfaceModel NewModel() const;

//! Returns True if <model> is a Model of IGES Norm <br>
Standard_EXPORT   Standard_Boolean IsSuitableModel(const Handle(Interface_InterfaceModel)& model) const;

//! Creates a new Unknown Entity for IGES (UndefinedEntity) <br>
Standard_EXPORT   Handle_Standard_Transient UnknownEntity() const;

//! Returns True if <ent> is an Unknown Entity for the Norm, i.e. <br>
//!           Type UndefinedEntity, status Unknown <br>
Standard_EXPORT   Standard_Boolean IsUnknownEntity(const Handle(Standard_Transient)& ent) const;
//Standard_EXPORT ~IGESData_Protocol();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
