// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntAna_Int3Pln_HeaderFile
#define _IntAna_Int3Pln_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
class StdFail_NotDone;
class Standard_DomainError;
class gp_Pln;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Intersection between 3 planes. The algorithm searches <br>
//!          for an intersection point. If two of the planes are <br>
//!          parallel or identical, IsEmpty returns TRUE. <br>
class IntAna_Int3Pln  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT IntAna_Int3Pln();

//! Determination of the intersection point between <br>
//!          3 planes. <br>
Standard_EXPORT IntAna_Int3Pln(const gp_Pln& P1,const gp_Pln& P2,const gp_Pln& P3);

//! Determination of the intersection point between <br>
//!          3 planes. <br>
Standard_EXPORT   void Perform(const gp_Pln& P1,const gp_Pln& P2,const gp_Pln& P3) ;
//! Returns True if the computation was successful. <br>
  Standard_Boolean IsDone() const;
//! Returns TRUE if there is no intersection POINT. <br>
//!          If 2 planes are identical or parallel, IsEmpty <br>
//!          will return TRUE. <br>
  Standard_Boolean IsEmpty() const;
//! Returns the intersection point. <br>
 const gp_Pnt& Value() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean done;
Standard_Boolean empt;
gp_Pnt pnt;


};


#include <IntAna_Int3Pln.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
