// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntPatch_Line_HeaderFile
#define _IntPatch_Line_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IntPatch_Line_HeaderFile
#include <Handle_IntPatch_Line.hxx>
#endif

#ifndef _IntPatch_IType_HeaderFile
#include <IntPatch_IType.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _IntSurf_TypeTrans_HeaderFile
#include <IntSurf_TypeTrans.hxx>
#endif
#ifndef _IntSurf_Situation_HeaderFile
#include <IntSurf_Situation.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
class Standard_DomainError;
class Standard_OutOfRange;


//! Definition of an intersection line between two <br>
//!          surfaces. <br>
//!          A line may be either geometric : line, circle, ellipse, <br>
//!          parabola, hyperbola, as defined in the class GLine, <br>
//!          or analytic, as defined in the class ALine, or defined <br>
//!          by a set of points (coming from a walking algorithm) as <br>
//!          defined in the class WLine. <br>
class IntPatch_Line : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 
//! To set the values returned by IsUIsoS1,.... <br>
//!          The default values are False. <br>
  void SetValue(const Standard_Boolean Uiso1,const Standard_Boolean Viso1,const Standard_Boolean Uiso2,const Standard_Boolean Viso2) ;
//! Returns the type of geometry 3d (Line, Circle, Parabola, <br>
//!          Hyperbola, Ellipse, Analytic, Walking, Restriction) <br>
  IntPatch_IType ArcType() const;
//! Returns TRUE if the intersection is a line of tangency <br>
//!          between the 2 patches. <br>
  Standard_Boolean IsTangent() const;
//! Returns the type of the transition of the line <br>
//!          for the first surface. The transition is "constant" <br>
//!          along the line. <br>
//!          The transition is IN if the line is oriented in such <br>
//!          a way that the system of vector (N1,N2,T) is right-handed, <br>
//!          where N1 is the normal to the first surface at a point P, <br>
//!                N2 is the normal to the second surface at a point P, <br>
//!                T  is the tangent to the intersection line at P. <br>
//!          If the system of vector is left-handed, the transition <br>
//!          is OUT. <br>
//!          When N1 and N2 are colinear all along the intersection <br>
//!          line, the transition will be <br>
//!           - TOUCH, if it is possible to use the 2nd derivatives <br>
//!             to determine the position of one surafce compared <br>
//!             to the other (see Situation) <br>
//!           - UNDECIDED otherwise. <br>
//! <br>
//!          If one of the transition is TOUCH or UNDECIDED, the other <br>
//!          one has got the same value. <br>
  IntSurf_TypeTrans TransitionOnS1() const;
//! Returns the type of the transition of the line <br>
//!          for the second surface. The transition is "constant" <br>
//!          along the line. <br>
  IntSurf_TypeTrans TransitionOnS2() const;
//! Returns the situation (INSIDE/OUTSIDE/UNKNOWN) of <br>
//!          the first patch compared to the second one, when <br>
//!          TransitionOnS1 or TransitionOnS2 returns TOUCH. <br>
//!          Otherwise, an exception is raised. <br>
  IntSurf_Situation SituationS1() const;
//! Returns the situation (INSIDE/OUTSIDE/UNKNOWN) of <br>
//!          the second patch compared to the first one, when <br>
//!          TransitionOnS1 or TransitionOnS2 returns TOUCH. <br>
//!          Otherwise, an exception is raised. <br>
  IntSurf_Situation SituationS2() const;
//! Returns TRUE if the intersection is a U isoparametric curve <br>
//!          on the first patch. <br>
  Standard_Boolean IsUIsoOnS1() const;
//! Returns TRUE if the intersection is a V isoparametric curve <br>
//!          on the first patch. <br>
  Standard_Boolean IsVIsoOnS1() const;
//! Returns TRUE if the intersection is a U isoparametric curve <br>
//!          on the second patch. <br>
  Standard_Boolean IsUIsoOnS2() const;
//! Returns TRUE if the intersection is a V isoparametric curve <br>
//!          on the second patch. <br>
  Standard_Boolean IsVIsoOnS2() const;
//Standard_EXPORT ~IntPatch_Line();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! To initialize the fields, when the transitions <br>
//!          are In or Out. <br>
Standard_EXPORT IntPatch_Line(const Standard_Boolean Tang,const IntSurf_TypeTrans Trans1,const IntSurf_TypeTrans Trans2);

//! To initialize the fields, when the transitions <br>
//!          are Touch. <br>
Standard_EXPORT IntPatch_Line(const Standard_Boolean Tang,const IntSurf_Situation Situ1,const IntSurf_Situation Situ2);

//! To initialize the fields, when the transitions <br>
//!          are Undecided. <br>
Standard_EXPORT IntPatch_Line(const Standard_Boolean Tang);


 // Fields PROTECTED
 //
IntPatch_IType typ;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean tg;
IntSurf_TypeTrans tS1;
IntSurf_TypeTrans tS2;
IntSurf_Situation sit1;
IntSurf_Situation sit2;
Standard_Boolean uS1;
Standard_Boolean vS1;
Standard_Boolean uS2;
Standard_Boolean vS2;


};


#include <IntPatch_Line.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
