// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntSurf_QuadricTool_HeaderFile
#define _IntSurf_QuadricTool_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class IntSurf_Quadric;
class gp_Vec;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class provides a tool on a quadric that can be <br>
//!          used to instantiates the Walking algorithmes (see <br>
//!          package IntWalk) with a Quadric from IntSurf <br>
//!          as implicit surface. <br>
class IntSurf_QuadricTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! Returns the value of the function. <br>
static  Standard_Real Value(const IntSurf_Quadric& Quad,const Standard_Real X,const Standard_Real Y,const Standard_Real Z) ;
//! Returns the gradient of the function. <br>
static  void Gradient(const IntSurf_Quadric& Quad,const Standard_Real X,const Standard_Real Y,const Standard_Real Z,gp_Vec& V) ;
//! Returns the value and the gradient. <br>
static  void ValueAndGradient(const IntSurf_Quadric& Quad,const Standard_Real X,const Standard_Real Y,const Standard_Real Z,Standard_Real& Val,gp_Vec& Grad) ;

//! returns the tolerance of the zero of the implicit function <br>
Standard_EXPORT static  Standard_Real Tolerance(const IntSurf_Quadric& Quad) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <IntSurf_QuadricTool.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
