// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntSurf_Transition_HeaderFile
#define _IntSurf_Transition_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _IntSurf_TypeTrans_HeaderFile
#include <IntSurf_TypeTrans.hxx>
#endif
#ifndef _IntSurf_Situation_HeaderFile
#include <IntSurf_Situation.hxx>
#endif
class Standard_DomainError;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Definition of the transition at the intersection <br>
//!          between an intersection line and a restriction curve <br>
//!          on a surface. <br>
class IntSurf_Transition  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Empty constructor. Creates an UNDECIDED transition. <br>
Standard_EXPORT IntSurf_Transition();

//! Create a IN or OUT transition <br>
Standard_EXPORT IntSurf_Transition(const Standard_Boolean Tangent,const IntSurf_TypeTrans Type);

//! Create a TOUCH transition. <br>
Standard_EXPORT IntSurf_Transition(const Standard_Boolean Tangent,const IntSurf_Situation Situ,const Standard_Boolean Oppos);
//! Set the values of an IN or OUT transition. <br>
  void SetValue(const Standard_Boolean Tangent,const IntSurf_TypeTrans Type) ;
//! Set the values of a TOUCH transition. <br>
  void SetValue(const Standard_Boolean Tangent,const IntSurf_Situation Situ,const Standard_Boolean Oppos) ;
//! Set the values of an UNDECIDED transition. <br>
  void SetValue() ;
//! Returns the type of Transition (in/out/touch/undecided) <br>
//!          for the arc given by value. This the transition of <br>
//!          the intersection line compared to the Arc of restriction, <br>
//!          i-e when the function returns INSIDE for example, it <br>
//!          means that the intersection line goes inside the <br>
//!          part of plane limited by the arc of restriction. <br>
  IntSurf_TypeTrans TransitionType() const;
//! Returns TRUE if the point is tangent to the arc <br>
//!          given by Value. <br>
//!          An exception is raised if TransitionType returns UNDECIDED. <br>
  Standard_Boolean IsTangent() const;
//! Returns a significant value if TransitionType returns <br>
//!          TOUCH. In this case, the function returns : <br>
//!          INSIDE when the intersection line remains inside the Arc, <br>
//!          OUTSIDE when it remains outside the Arc, <br>
//!          UNKNOWN when the calsulus cannot give results. <br>
//!          If TransitionType returns IN, or OUT, or UNDECIDED, a <br>
//!          exception is raised. <br>
  IntSurf_Situation Situation() const;
//! returns a significant value if TransitionType returns <br>
//!          TOUCH. <br>
//!          In this case, the function returns true when <br>
//!          the 2 curves locally define two different parts of the <br>
//!          space. <br>
//!          If TransitionType returns IN or OUT or UNDECIDED, an <br>
//!          exception is raised. <br>
  Standard_Boolean IsOpposite() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean tangent;
IntSurf_TypeTrans typetra;
IntSurf_Situation situat;
Standard_Boolean oppos;


};


#include <IntSurf_Transition.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
