// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntTools_CommonPrt_HeaderFile
#define _IntTools_CommonPrt_HeaderFile

#ifndef _TopoDS_Edge_HeaderFile
#include <TopoDS_Edge.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _IntTools_Range_HeaderFile
#include <IntTools_Range.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _IntTools_SequenceOfRanges_HeaderFile
#include <IntTools_SequenceOfRanges.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
class TopoDS_Edge;
class IntTools_Range;
class IntTools_SequenceOfRanges;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The class  is  to  describe a  common  part <br>
//!          between two edges in  3-d space. <br>
class IntTools_CommonPrt  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor <br>
Standard_EXPORT IntTools_CommonPrt();


//! Copy  constructor <br>
Standard_EXPORT IntTools_CommonPrt(const IntTools_CommonPrt& aCPrt);


Standard_EXPORT   IntTools_CommonPrt& Assign(const IntTools_CommonPrt& Other) ;
  IntTools_CommonPrt& operator =(const IntTools_CommonPrt& Other) 
{
  return Assign(Other);
}



//! Sets the first edge. <br>
Standard_EXPORT   void SetEdge1(const TopoDS_Edge& anE) ;


//! Sets the second edge. <br>
Standard_EXPORT   void SetEdge2(const TopoDS_Edge& anE) ;


//! Sets the type of  the common  part <br>
//! Vertex  or  Edge <br>
Standard_EXPORT   void SetType(const TopAbs_ShapeEnum aType) ;


//! Sets the range of first edge. <br>
Standard_EXPORT   void SetRange1(const IntTools_Range& aR) ;


//! Sets the range of first edge. <br>
Standard_EXPORT   void SetRange1(const Standard_Real tf,const Standard_Real tl) ;


//! Appends the range of second edge. <br>
Standard_EXPORT   void AppendRange2(const IntTools_Range& aR) ;


//! Appends the range of second edge. <br>
Standard_EXPORT   void AppendRange2(const Standard_Real tf,const Standard_Real tl) ;


//! Sets a parameter of first vertex <br>
Standard_EXPORT   void SetVertexParameter1(const Standard_Real tV) ;


//! Sets a parameter of second vertex <br>
Standard_EXPORT   void SetVertexParameter2(const Standard_Real tV) ;


//! Returns the first edge. <br>
Standard_EXPORT  const TopoDS_Edge& Edge1() const;


//! Returns the second edge <br>
Standard_EXPORT  const TopoDS_Edge& Edge2() const;


//! Returns the type of  the common  part <br>
Standard_EXPORT   TopAbs_ShapeEnum Type() const;


//! Returns the range of first edge <br>
Standard_EXPORT  const IntTools_Range& Range1() const;


//! Returns the range of first edge. <br>
Standard_EXPORT   void Range1(Standard_Real& tf,Standard_Real& tl) const;


//! Returns the  ranges of second edge. <br>
Standard_EXPORT  const IntTools_SequenceOfRanges& Ranges2() const;


//! Returns the  ranges of second edge. <br>
Standard_EXPORT   IntTools_SequenceOfRanges& ChangeRanges2() ;


//! Returns parameter of first vertex <br>
Standard_EXPORT   Standard_Real VertexParameter1() const;


//! Returns parameter of second vertex <br>
Standard_EXPORT   Standard_Real VertexParameter2() const;


//! Copies me to anOther <br>
Standard_EXPORT   void Copy(IntTools_CommonPrt& anOther) const;


//! Modifier <br>
Standard_EXPORT   Standard_Boolean AllNullFlag() const;


//! Selector <br>
Standard_EXPORT   void SetAllNullFlag(const Standard_Boolean aFlag) ;


//! Modifier <br>
Standard_EXPORT   void SetBoundingPoints(const gp_Pnt& aP1,const gp_Pnt& aP2) ;


//! Selector <br>
Standard_EXPORT   void BoundingPoints(gp_Pnt& aP1,gp_Pnt& aP2) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Edge myEdge1;
TopoDS_Edge myEdge2;
TopAbs_ShapeEnum myType;
IntTools_Range myRange1;
Standard_Real myVertPar1;
Standard_Real myVertPar2;
IntTools_SequenceOfRanges myRanges2;
Standard_Boolean myAllNullFlag;
gp_Pnt myPnt1;
gp_Pnt myPnt2;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
