// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntTools_LineConstructor_HeaderFile
#define _IntTools_LineConstructor_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TColStd_SequenceOfReal_HeaderFile
#include <TColStd_SequenceOfReal.hxx>
#endif
#ifndef _Handle_Adaptor3d_TopolTool_HeaderFile
#include <Handle_Adaptor3d_TopolTool.hxx>
#endif
#ifndef _Handle_GeomAdaptor_HSurface_HeaderFile
#include <Handle_GeomAdaptor_HSurface.hxx>
#endif
#ifndef _Handle_IntPatch_Line_HeaderFile
#include <Handle_IntPatch_Line.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Adaptor3d_TopolTool;
class GeomAdaptor_HSurface;
class StdFail_NotDone;
class Standard_OutOfRange;
class IntPatch_Line;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Splits given Line. <br>
//! <br>
class IntTools_LineConstructor  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor <br>
Standard_EXPORT IntTools_LineConstructor();


//! Initializes me by two surfaces and corresponding <br>
//! tools which represent boundaries of surfaces <br>
Standard_EXPORT   void Load(const Handle(Adaptor3d_TopolTool)& D1,const Handle(Adaptor3d_TopolTool)& D2,const Handle(GeomAdaptor_HSurface)& S1,const Handle(GeomAdaptor_HSurface)& S2) ;


//! Splits line <br>
Standard_EXPORT   void Perform(const Handle(IntPatch_Line)& L) ;


//! Returns True if splitting <br>
//! was successful <br>
Standard_EXPORT   Standard_Boolean IsDone() const;


//! Returns number of splits <br>
Standard_EXPORT   Standard_Integer NbParts() const;


//! Return first and last parameters <br>
//! for given index of split <br>
Standard_EXPORT   void Part(const Standard_Integer I,Standard_Real& WFirst,Standard_Real& WLast) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void PeriodicLine(const Handle(IntPatch_Line)& L) const;


 // Fields PRIVATE
 //
Standard_Boolean done;
TColStd_SequenceOfReal seqp;
Handle_Adaptor3d_TopolTool myDom1;
Handle_Adaptor3d_TopolTool myDom2;
Handle_GeomAdaptor_HSurface myHS1;
Handle_GeomAdaptor_HSurface myHS2;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
