// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntTools_Range_HeaderFile
#define _IntTools_Range_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The class describes the  1-d range <br>
//!          [myFirst, myLast]. <br>
class IntTools_Range  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor <br>
Standard_EXPORT IntTools_Range();


//! Initialize me by range boundaries <br>
Standard_EXPORT IntTools_Range(const Standard_Real aFirst,const Standard_Real aLast);


//! Modifier <br>
Standard_EXPORT   void SetFirst(const Standard_Real aFirst) ;


//! Modifier <br>
Standard_EXPORT   void SetLast(const Standard_Real aLast) ;


//! Selector <br>
Standard_EXPORT   Standard_Real First() const;


//! Selector <br>
Standard_EXPORT   Standard_Real Last() const;


//! Selector <br>
Standard_EXPORT   void Range(Standard_Real& aFirst,Standard_Real& aLast) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real myFirst;
Standard_Real myLast;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
