// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Intrv_Intervals_HeaderFile
#define _Intrv_Intervals_HeaderFile

#ifndef _Intrv_SequenceOfInterval_HeaderFile
#include <Intrv_SequenceOfInterval.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_OutOfRange;
class Intrv_Interval;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The class  Intervals is a  sorted  sequence of non <br>
//!          overlapping  Real Intervals. <br>
class Intrv_Intervals  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a void sequence of intervals. <br>
Standard_EXPORT Intrv_Intervals();

//! Creates a sequence of one interval. <br>
Standard_EXPORT Intrv_Intervals(const Intrv_Interval& Int);

//! Creates   by   copying  an   existing  sequence of <br>
//!          intervals. <br>
Standard_EXPORT Intrv_Intervals(const Intrv_Intervals& Int);

//! Intersects the intervals with the interval <Tool>. <br>
Standard_EXPORT   void Intersect(const Intrv_Interval& Tool) ;

//! Intersects the intervals with the intervals in the <br>
//!          sequence  <Tool>. <br>
Standard_EXPORT   void Intersect(const Intrv_Intervals& Tool) ;


Standard_EXPORT   void Subtract(const Intrv_Interval& Tool) ;


Standard_EXPORT   void Subtract(const Intrv_Intervals& Tool) ;


Standard_EXPORT   void Unite(const Intrv_Interval& Tool) ;


Standard_EXPORT   void Unite(const Intrv_Intervals& Tool) ;


Standard_EXPORT   void XUnite(const Intrv_Interval& Tool) ;


Standard_EXPORT   void XUnite(const Intrv_Intervals& Tool) ;

  Standard_Integer NbIntervals() const;

 const Intrv_Interval& Value(const Standard_Integer Index) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Intrv_SequenceOfInterval myInter;


};


#include <Intrv_Intervals.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
