// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _LocOpe_CurveShapeIntersector_HeaderFile
#define _LocOpe_CurveShapeIntersector_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _LocOpe_SequenceOfPntFace_HeaderFile
#include <LocOpe_SequenceOfPntFace.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
class StdFail_NotDone;
class Standard_OutOfRange;
class gp_Ax1;
class TopoDS_Shape;
class gp_Circ;
class LocOpe_PntFace;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This  class  provides  the intersection between an <br>
//!          axis  or  a circle and  the  faces of a shape. The <br>
//!          intersection   points  are   sorted in  increasing <br>
//!          parameter along the axis. <br>
class LocOpe_CurveShapeIntersector  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! Empty constructor. <br>
LocOpe_CurveShapeIntersector();
//! Creates  and performs the intersection     betwwen <br>
//!          <Ax1> and <S>. <br>
LocOpe_CurveShapeIntersector(const gp_Ax1& Axis,const TopoDS_Shape& S);
//! Creates  and performs yte intersection     betwwen <br>
//!          <C> and <S>. <br>
LocOpe_CurveShapeIntersector(const gp_Circ& C,const TopoDS_Shape& S);

//! Performs the intersection between <Ax1 and <S>. <br>
Standard_EXPORT   void Init(const gp_Ax1& Axis,const TopoDS_Shape& S) ;

//! Performs the intersection between <Ax1 and <S>. <br>
Standard_EXPORT   void Init(const gp_Circ& C,const TopoDS_Shape& S) ;
//! Returns <Standard_True>  if the  intersection  has <br>
//!          been done. <br>
  Standard_Boolean IsDone() const;
//! Returns the number of intersection point. <br>
  Standard_Integer NbPoints() const;
//! Returns the intersection  point  of range <Index>. <br>
//!          The points  are   sorted in increasing  order   of <br>
//!          parameter along the axis. <br>
 const LocOpe_PntFace& Point(const Standard_Integer Index) const;

//! Searches the   first intersection  point   located <br>
//!          after the  parameter  <From>, wich  orientation is <br>
//!          not       TopAbs_EXTERNAL.      If found,  returns <br>
//!          <Standard_True>.  <Or> contains the orientation of <br>
//!          the  point, <IndFrom>  and  <IndTo> represents the <br>
//!          interval of index  in the sequence of intersection <br>
//!          point  corresponding  to   the point. (IndFrom  <= <br>
//!          IndTo). <br>
//! <br>
//!          Otherwise, returns <Standard_False>. <br>
Standard_EXPORT   Standard_Boolean LocalizeAfter(const Standard_Real From,TopAbs_Orientation& Or,Standard_Integer& IndFrom,Standard_Integer& IndTo) const;

//! Searches  the first intersection point     located <br>
//!          before  the parameter <From>,  wich orientation is <br>
//!          not      TopAbs_EXTERNAL.      If  found,  returns <br>
//!          <Standard_True>.  <Or> contains the orientation of <br>
//!          the point,  <IndFrom>  and <IndTo>  represents the <br>
//!          interval of index  in the sequence of intersection <br>
//!          point  corresponding   to the point   (IndFrom  <= <br>
//!          IndTo). <br>
//! <br>
//!          Otherwise, returns <Standard_False>. <br>
Standard_EXPORT   Standard_Boolean LocalizeBefore(const Standard_Real From,TopAbs_Orientation& Or,Standard_Integer& IndFrom,Standard_Integer& IndTo) const;

//! Searches  the first intersection point     located <br>
//!          after the index <FromInd>  ( >= FromInd + 1), wich <br>
//!          orientation   is   not TopAbs_EXTERNAL.   If found, <br>
//!          returns   <Standard_True>.   <Or>  contains    the <br>
//!          orientation of the  point, <IndFrom>  and  <IndTo> <br>
//!          represents the interval  of index in  the sequence <br>
//!          of  intersection  point     corresponding to   the <br>
//!          point. (IndFrom <= IndTo). <br>
//! <br>
//!          Otherwise, returns <Standard_False>. <br>
Standard_EXPORT   Standard_Boolean LocalizeAfter(const Standard_Integer FromInd,TopAbs_Orientation& Or,Standard_Integer& IndFrom,Standard_Integer& IndTo) const;

//! Searches the  first  intersection   point  located <br>
//!          before the index <FromInd>  ( <= FromInd -1), wich <br>
//!          orientation is   not TopAbs_EXTERNAL.   If   found, <br>
//!          returns   <Standard_True>.  <Or>  contains     the <br>
//!          orientation  of the  point,  <IndFrom> and <IndTo> <br>
//!          represents the interval  of index  in the sequence <br>
//!          of  intersection  point corresponding to the point <br>
//!          (IndFrom <= IndTo). <br>
//! <br>
//!          Otherwise, returns <Standard_False>. <br>
Standard_EXPORT   Standard_Boolean LocalizeBefore(const Standard_Integer FromInd,TopAbs_Orientation& Or,Standard_Integer& IndFrom,Standard_Integer& IndTo) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myDone;
LocOpe_SequenceOfPntFace myPoints;


};


#include <LocOpe_CurveShapeIntersector.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
