// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MAT2d_Circuit_HeaderFile
#define _MAT2d_Circuit_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_MAT2d_Circuit_HeaderFile
#include <Handle_MAT2d_Circuit.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TColGeom2d_SequenceOfGeometry_HeaderFile
#include <TColGeom2d_SequenceOfGeometry.hxx>
#endif
#ifndef _MAT2d_DataMapOfIntegerConnexion_HeaderFile
#include <MAT2d_DataMapOfIntegerConnexion.hxx>
#endif
#ifndef _MAT2d_DataMapOfBiIntSequenceOfInteger_HeaderFile
#include <MAT2d_DataMapOfBiIntSequenceOfInteger.hxx>
#endif
#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_MAT2d_Connexion_HeaderFile
#include <Handle_MAT2d_Connexion.hxx>
#endif
#ifndef _Handle_Geom2d_Geometry_HeaderFile
#include <Handle_Geom2d_Geometry.hxx>
#endif
class MAT2d_SequenceOfSequenceOfGeometry;
class MAT2d_SequenceOfBoolean;
class MAT2d_Connexion;
class TColGeom2d_SequenceOfGeometry;
class MAT2d_BiInt;
class MAT2d_SequenceOfConnexion;
class MAT2d_MiniPath;
class Geom2d_Geometry;
class TColStd_SequenceOfInteger;


//! Constructs a circuit on a set of lines. <br>
//! <br>
//! <br>
class MAT2d_Circuit : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT MAT2d_Circuit();


Standard_EXPORT   void Perform(MAT2d_SequenceOfSequenceOfGeometry& aFigure,const MAT2d_SequenceOfBoolean& IsClosed,const Standard_Integer IndRefLine,const Standard_Boolean Trigo) ;

//! Returns the Number of Items . <br>
Standard_EXPORT   Standard_Integer NumberOfItems() const;

//! Returns the item at position <Index> in <me>. <br>
Standard_EXPORT   Handle_Geom2d_Geometry Value(const Standard_Integer Index) const;

//! Returns the number of items on the line <IndexLine>. <br>
Standard_EXPORT   Standard_Integer LineLength(const Standard_Integer IndexLine) const;

//! Returns the set of index of the items in <me>corresponding <br>
//!          to the curve <IndCurve> on the line <IndLine> from the <br>
//!          initial figure. <br>
//! <br>
Standard_EXPORT  const TColStd_SequenceOfInteger& RefToEqui(const Standard_Integer IndLine,const Standard_Integer IndCurve) const;

//!  Returns the Connexion on the item <Index> in me. <br>
Standard_EXPORT   Handle_MAT2d_Connexion Connexion(const Standard_Integer Index) const;

//! Returns <True> is there is a connexion on the item <Index> <br>
//!          in <me>. <br>
Standard_EXPORT   Standard_Boolean ConnexionOn(const Standard_Integer Index) const;
//Standard_EXPORT ~MAT2d_Circuit();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Boolean PassByLast(const Handle(MAT2d_Connexion)& C1,const Handle(MAT2d_Connexion)& C2) const;


Standard_EXPORT   Standard_Real Side(const Handle(MAT2d_Connexion)& C,const TColGeom2d_SequenceOfGeometry& Line) const;


Standard_EXPORT   void UpDateLink(const Standard_Integer IFirst,const Standard_Integer ILine,const Standard_Integer ICurveFirst,const Standard_Integer ICurveLast) ;


Standard_EXPORT   void SortRefToEqui(const MAT2d_BiInt& aBiInt) ;


Standard_EXPORT   void InitOpen(TColGeom2d_SequenceOfGeometry& Line) const;


Standard_EXPORT   void InsertCorner(TColGeom2d_SequenceOfGeometry& Line) const;


Standard_EXPORT   void DoubleLine(TColGeom2d_SequenceOfGeometry& Line,MAT2d_SequenceOfConnexion& Connexions,const Handle(MAT2d_Connexion)& Father,const Standard_Real Side) const;


Standard_EXPORT   void ConstructCircuit(const MAT2d_SequenceOfSequenceOfGeometry& aFigure,const Standard_Integer IndRefLine,const MAT2d_MiniPath& aPath) ;


 // Fields PRIVATE
 //
Standard_Real direction;
TColGeom2d_SequenceOfGeometry geomElements;
MAT2d_DataMapOfIntegerConnexion connexionMap;
MAT2d_DataMapOfBiIntSequenceOfInteger linkRefEqui;
TColStd_SequenceOfInteger linesLength;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
