// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MgtBRep_TranslateTool_HeaderFile
#define _MgtBRep_TranslateTool_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_MgtBRep_TranslateTool_HeaderFile
#include <Handle_MgtBRep_TranslateTool.hxx>
#endif

#ifndef _MgtBRep_TriangleMode_HeaderFile
#include <MgtBRep_TriangleMode.hxx>
#endif
#ifndef _MgtTopoDS_TranslateTool_HeaderFile
#include <MgtTopoDS_TranslateTool.hxx>
#endif
#ifndef _Handle_PGeom_Curve_HeaderFile
#include <Handle_PGeom_Curve.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Handle_PGeom2d_Curve_HeaderFile
#include <Handle_PGeom2d_Curve.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Handle_PGeom_Surface_HeaderFile
#include <Handle_PGeom_Surface.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Handle_PTopoDS_HShape_HeaderFile
#include <Handle_PTopoDS_HShape.hxx>
#endif
class Standard_TypeMismatch;
class PGeom_Curve;
class Geom_Curve;
class PTColStd_TransientPersistentMap;
class PTColStd_PersistentTransientMap;
class PGeom2d_Curve;
class Geom2d_Curve;
class PGeom_Surface;
class Geom_Surface;
class TopoDS_Shape;
class PTopoDS_HShape;


//! The TranslateTool class is provided to support the <br>
//!          translation of BRep topological data structures. <br>
class MgtBRep_TranslateTool : public MgtTopoDS_TranslateTool {

public:
 // Methods PUBLIC
 // 

//! Creates a new TranslateTool <br>
Standard_EXPORT MgtBRep_TranslateTool(const MgtBRep_TriangleMode aTriMode);


Standard_EXPORT   void Add(TopoDS_Shape& S1,const TopoDS_Shape& S2) const;


Standard_EXPORT   void MakeVertex(TopoDS_Shape& S) const;


Standard_EXPORT   void MakeVertex(const Handle(PTopoDS_HShape)& S) const;


Standard_EXPORT   void MakeEdge(TopoDS_Shape& S) const;


Standard_EXPORT   void MakeEdge(const Handle(PTopoDS_HShape)& S) const;


Standard_EXPORT   void MakeWire(TopoDS_Shape& S) const;


Standard_EXPORT   void MakeWire(const Handle(PTopoDS_HShape)& S) const;


Standard_EXPORT   void MakeFace(TopoDS_Shape& S) const;


Standard_EXPORT   void MakeFace(const Handle(PTopoDS_HShape)& S) const;


Standard_EXPORT   void MakeShell(TopoDS_Shape& S) const;


Standard_EXPORT   void MakeShell(const Handle(PTopoDS_HShape)& S) const;


Standard_EXPORT   void MakeSolid(TopoDS_Shape& S) const;


Standard_EXPORT   void MakeSolid(const Handle(PTopoDS_HShape)& S) const;


Standard_EXPORT   void MakeCompSolid(TopoDS_Shape& S) const;


Standard_EXPORT   void MakeCompSolid(const Handle(PTopoDS_HShape)& S) const;


Standard_EXPORT   void MakeCompound(TopoDS_Shape& S) const;


Standard_EXPORT   void MakeCompound(const Handle(PTopoDS_HShape)& S) const;


Standard_EXPORT virtual  void UpdateVertex(const TopoDS_Shape& S1,const Handle(PTopoDS_HShape)& S2,PTColStd_TransientPersistentMap& M) const;


Standard_EXPORT virtual  void UpdateVertex(const Handle(PTopoDS_HShape)& S1,TopoDS_Shape& S2,PTColStd_PersistentTransientMap& M) const;


Standard_EXPORT virtual  void UpdateEdge(const TopoDS_Shape& S1,const Handle(PTopoDS_HShape)& S2,PTColStd_TransientPersistentMap& M) const;


Standard_EXPORT virtual  void UpdateEdge(const Handle(PTopoDS_HShape)& S1,TopoDS_Shape& S2,PTColStd_PersistentTransientMap& M) const;


Standard_EXPORT virtual  void UpdateFace(const TopoDS_Shape& S1,const Handle(PTopoDS_HShape)& S2,PTColStd_TransientPersistentMap& M) const;


Standard_EXPORT virtual  void UpdateFace(const Handle(PTopoDS_HShape)& S1,TopoDS_Shape& S2,PTColStd_PersistentTransientMap& M) const;
//Standard_EXPORT ~MgtBRep_TranslateTool();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Translates a Transient Curve onto a Persistent Curve <br>
Standard_EXPORT   Handle_PGeom_Curve Translate(const Handle(Geom_Curve)& TC,PTColStd_TransientPersistentMap& M) const;

//! Translates a Persistent Curve onto a Transient Curve <br>
Standard_EXPORT   Handle_Geom_Curve Translate(const Handle(PGeom_Curve)& PC,PTColStd_PersistentTransientMap& M) const;

//! Translates a Transient Curve2d onto a Persistent Curve <br>
Standard_EXPORT   Handle_PGeom2d_Curve Translate(const Handle(Geom2d_Curve)& TC,PTColStd_TransientPersistentMap& M) const;

//! Translates a Persistent Curve2d onto a Transient Curve <br>
Standard_EXPORT   Handle_Geom2d_Curve Translate(const Handle(PGeom2d_Curve)& PC,PTColStd_PersistentTransientMap& M) const;

//! Translates a Transient Surface onto a Persistent Curve <br>
Standard_EXPORT   Handle_PGeom_Surface Translate(const Handle(Geom_Surface)& TS,PTColStd_TransientPersistentMap& M) const;

//! Translates a Persistent Surface onto a Transient Curve <br>
Standard_EXPORT   Handle_Geom_Surface Translate(const Handle(PGeom_Surface)& PS,PTColStd_PersistentTransientMap& M) const;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
MgtBRep_TriangleMode myTriangleMode;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
