// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MoniTool_AttrList_HeaderFile
#define _MoniTool_AttrList_HeaderFile

#ifndef _Handle_Dico_DictionaryOfTransient_HeaderFile
#include <Handle_Dico_DictionaryOfTransient.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Standard_Type_HeaderFile
#include <Handle_Standard_Type.hxx>
#endif
#ifndef _MoniTool_ValueType_HeaderFile
#include <MoniTool_ValueType.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Dico_DictionaryOfTransient;
class Standard_Transient;
class Standard_Type;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! a AttrList allows to record a list of attributes as Transients <br>
//!           which can be edited, changed ... <br>
//!           Each one is identified by a name <br>
class MoniTool_AttrList  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an AttrList, empty <br>
Standard_EXPORT MoniTool_AttrList();

//! Creates an AttrList from another one, definitions are shared <br>
//!           (calls SameAttributes) <br>
Standard_EXPORT MoniTool_AttrList(const MoniTool_AttrList& other);

//! Adds an attribute with a given name (replaces the former one <br>
//!           with the same name if already exists) <br>
Standard_EXPORT   void SetAttribute(const Standard_CString name,const Handle(Standard_Transient)& val) ;

//! Removes an attribute <br>
//!           Returns True when done, False if this attribute did not exist <br>
Standard_EXPORT   Standard_Boolean RemoveAttribute(const Standard_CString name) ;

//! Returns an attribute from its name, filtered by a type <br>
//!           If no attribute has this name, or if it is not kind of this <br>
//!           type, <val> is Null and returned value is False <br>
//!           Else, it is True <br>
Standard_EXPORT   Standard_Boolean GetAttribute(const Standard_CString name,const Handle(Standard_Type)& type,Handle(Standard_Transient)& val) const;

//! Returns an attribute from its name. Null Handle if not <br>
//!           recorded         (whatever Transient, Integer, Real ...) <br>
//!           Integer is recorded as IntVal <br>
//!           Real is recorded as RealVal <br>
//!           Text is recorded as HAsciiString <br>
Standard_EXPORT   Handle_Standard_Transient Attribute(const Standard_CString name) const;

//! Returns the type of an attribute : <br>
//!           ValueInt , ValueReal , ValueText (String) , ValueIdent (any) <br>
//!           or ValueVoid (not recorded) <br>
Standard_EXPORT   MoniTool_ValueType AttributeType(const Standard_CString name) const;

//! Adds an integer value for an attribute <br>
Standard_EXPORT   void SetIntegerAttribute(const Standard_CString name,const Standard_Integer val) ;

//! Returns an attribute from its name, as integer <br>
//!           If no attribute has this name, or not an integer, <br>
//!           <val> is 0 and returned value is False <br>
//!           Else, it is True <br>
Standard_EXPORT   Standard_Boolean GetIntegerAttribute(const Standard_CString name,Standard_Integer& val) const;

//! Returns an integer attribute from its name. 0 if not recorded <br>
Standard_EXPORT   Standard_Integer IntegerAttribute(const Standard_CString name) const;

//! Adds a real value for an attribute <br>
Standard_EXPORT   void SetRealAttribute(const Standard_CString name,const Standard_Real val) ;

//! Returns an attribute from its name, as real <br>
//!           If no attribute has this name, or not a real <br>
//!           <val> is 0.0 and returned value is False <br>
//!           Else, it is True <br>
Standard_EXPORT   Standard_Boolean GetRealAttribute(const Standard_CString name,Standard_Real& val) const;

//! Returns a real attribute from its name. 0.0 if not recorded <br>
Standard_EXPORT   Standard_Real RealAttribute(const Standard_CString name) const;

//! Adds a String value for an attribute <br>
Standard_EXPORT   void SetStringAttribute(const Standard_CString name,const Standard_CString val) ;

//! Returns an attribute from its name, as String <br>
//!           If no attribute has this name, or not a String <br>
//!           <val> is 0.0 and returned value is False <br>
//!           Else, it is True <br>
Standard_EXPORT   Standard_Boolean GetStringAttribute(const Standard_CString name,Standard_CString& val) const;

//! Returns a String attribute from its name. "" if not recorded <br>
Standard_EXPORT   Standard_CString StringAttribute(const Standard_CString name) const;

//! Returns the exhaustive list of attributes <br>
Standard_EXPORT   Handle_Dico_DictionaryOfTransient AttrList() const;

//! Gets the list of attributes from <other>, as such, i.e. <br>
//!           not copied : attributes are shared, any attribute edited, <br>
//!           added, or removed in <other> is also in <me> and vice versa <br>
//!           The former list of attributes of <me> is dropped <br>
Standard_EXPORT   void SameAttributes(const MoniTool_AttrList& other) ;

//! Gets the list of attributes from <other>, by copying it <br>
//!           By default, considers all the attributes from <other> <br>
//!           If <fromname> is given, considers only the attributes with <br>
//!           name beginning by <fromname> <br>
//! <br>
//!           For each attribute, if <copied> is True (D), its value is also <br>
//!           copied if it is a basic type (Integer,Real,String), else it <br>
//!           remains shared between <other> and <me> <br>
//! <br>
//!           These new attributes are added to the existing ones in <me>, <br>
//!           in case of same name, they replace the existing ones <br>
Standard_EXPORT   void GetAttributes(const MoniTool_AttrList& other,const Standard_CString fromname = "",const Standard_Boolean copied = Standard_True) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Dico_DictionaryOfTransient theattrib;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
