// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _PlotMgt_PlotterDriver_HeaderFile
#define _PlotMgt_PlotterDriver_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_PlotMgt_PlotterDriver_HeaderFile
#include <Handle_PlotMgt_PlotterDriver.hxx>
#endif

#ifndef _Aspect_FStream_HeaderFile
#include <Aspect_FStream.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Handle_PlotMgt_Plotter_HeaderFile
#include <Handle_PlotMgt_Plotter.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Aspect_TypeOfColorSpace_HeaderFile
#include <Aspect_TypeOfColorSpace.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Aspect_TypeOfPrimitive_HeaderFile
#include <Aspect_TypeOfPrimitive.hxx>
#endif
#ifndef _TShort_Array1OfShortReal_HeaderFile
#include <TShort_Array1OfShortReal.hxx>
#endif
#ifndef _Handle_PlotMgt_HListOfMFTFonts_HeaderFile
#include <Handle_PlotMgt_HListOfMFTFonts.hxx>
#endif
#ifndef _Handle_PlotMgt_HListOfMFTSizes_HeaderFile
#include <Handle_PlotMgt_HListOfMFTSizes.hxx>
#endif
#ifndef _Handle_PlotMgt_TextManager_HeaderFile
#include <Handle_PlotMgt_TextManager.hxx>
#endif
#ifndef _Handle_Aspect_ColorMap_HeaderFile
#include <Handle_Aspect_ColorMap.hxx>
#endif
#ifndef _Handle_Aspect_TypeMap_HeaderFile
#include <Handle_Aspect_TypeMap.hxx>
#endif
#ifndef _Handle_Aspect_WidthMap_HeaderFile
#include <Handle_Aspect_WidthMap.hxx>
#endif
#ifndef _Handle_Aspect_MarkMap_HeaderFile
#include <Handle_Aspect_MarkMap.hxx>
#endif
#ifndef _Aspect_Driver_HeaderFile
#include <Aspect_Driver.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Aspect_PlotMode_HeaderFile
#include <Aspect_PlotMode.hxx>
#endif
#ifndef _Handle_Aspect_FontMap_HeaderFile
#include <Handle_Aspect_FontMap.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Quantity_Factor_HeaderFile
#include <Quantity_Factor.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Aspect_TypeOfText_HeaderFile
#include <Aspect_TypeOfText.hxx>
#endif
#ifndef _Quantity_Ratio_HeaderFile
#include <Quantity_Ratio.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
class PlotMgt_Plotter;
class PlotMgt_HListOfMFTFonts;
class PlotMgt_HListOfMFTSizes;
class PlotMgt_TextManager;
class Aspect_ColorMap;
class Aspect_TypeMap;
class Aspect_WidthMap;
class Aspect_MarkMap;
class Aspect_FontMap;
class Standard_Transient;
class TShort_Array1OfShortReal;
class TCollection_ExtendedString;
class TCollection_AsciiString;



class PlotMgt_PlotterDriver : public Aspect_Driver {

public:
 // Methods PUBLIC
 // 

//! Begins a new page of graphics in the plotter file name. <br>
Standard_EXPORT virtual  void BeginDraw()  = 0;


Standard_EXPORT virtual  void Close() ;
~PlotMgt_PlotterDriver()
{
  Close();
}



Standard_EXPORT virtual  Standard_Boolean Spool(const Aspect_PlotMode aPlotMode = Aspect_PM_FILEONLY,const Standard_CString aReserved1 = NULL,const Standard_Boolean aReserved2 = Standard_False) ;


Standard_EXPORT virtual  void SetLineAttrib(const Standard_Integer ColorIndex,const Standard_Integer TypeIndex,const Standard_Integer WidthIndex) ;


Standard_EXPORT virtual  void SetTextAttrib(const Standard_Integer ColorIndex,const Standard_Integer FontIndex) ;


Standard_EXPORT virtual  void SetTextAttrib(const Standard_Integer ColorIndex,const Standard_Integer FontIndex,const Quantity_PlaneAngle aSlant,const Quantity_Factor aHScale,const Quantity_Factor aWScale,const Standard_Boolean isUnderlined = Standard_False) ;


Standard_EXPORT virtual  void SetPolyAttrib(const Standard_Integer ColorIndex,const Standard_Integer TileIndex,const Standard_Boolean DrawEdge = Standard_False) ;


Standard_EXPORT virtual  void SetMarkerAttrib(const Standard_Integer ColorIndex,const Standard_Integer WidthIndex,const Standard_Boolean FillMarker = Standard_False) ;


Standard_EXPORT   void SetPixelSize(const Standard_Real aSize) ;

//! Begin an incremental polyline primitive of <aNumber> of points . <br>
//!  Warning: Points must be added by the the DrawPoint() method. <br>
Standard_EXPORT virtual  void BeginPolyline(const Standard_Integer aNumber) ;

//! Begin an incremental polygon primitive of <aNumber> of points . <br>
//!  Warning: Points must be added by the the DrawPoint() method. <br>
Standard_EXPORT virtual  void BeginPolygon(const Standard_Integer aNumber) ;

//! Begin a set of segments. <br>
//!  Warning: Segments must be added by the DrawSegment() method. <br>
Standard_EXPORT virtual  void BeginSegments() ;

//! Begin a set of circles or ellipses. <br>
//!  Warning: Arcs must be added by the DrawArc() methods. <br>
Standard_EXPORT virtual  void BeginArcs() ;

//! Begin a set of polygon circles or ellipses. <br>
//!  Warning: Arcs must be added by the DrawPolyArc() methods. <br>
Standard_EXPORT virtual  void BeginPolyArcs() ;

//! Begin a set of markers. <br>
//!  Warning: Markers must be added by the DrawMarker() method. <br>
Standard_EXPORT virtual  void BeginMarkers() ;

//! Begin a set of points. <br>
//!  Warning: Points must be added by the DrawPoint() method. <br>
Standard_EXPORT virtual  void BeginPoints() ;

//! Close the last Begining primitive <br>
Standard_EXPORT virtual  void ClosePrimitive() ;


Standard_EXPORT virtual  Standard_Boolean IsKnownImage(const Handle(Standard_Transient)& anImage) ;

//! Returns Standard_True and the Image Size in PIXEL <br>
//!          if the image file exist and can be computed by the driver, <br>
Standard_EXPORT virtual  Standard_Boolean SizeOfImageFile(const Standard_CString anImageFile,Standard_Integer& aWidth,Standard_Integer& aHeight) const;


Standard_EXPORT virtual  void ClearImage(const Handle(Standard_Transient)& anImageId) ;

//! Clears the image associated with the image file . <br>
Standard_EXPORT virtual  void ClearImageFile(const Standard_CString anImageFile) ;

//! Draws the image  in <me>. <br>
//!          <aX>, <aY> is the center of the image. <br>
//!          Image center must be defined in DPU space. <br>
Standard_EXPORT virtual  void DrawImage(const Handle(Standard_Transient)& anImageId,const Standard_ShortReal aX,const Standard_ShortReal aY) ;

//! Draws the image file in <me>. <br>
//!          <aX>, <aY> is the center of the image. <br>
//!          Image center must be defined in DPU space. <br>
Standard_EXPORT virtual  void DrawImageFile(const Standard_CString anImageFile,const Standard_ShortReal aX,const Standard_ShortReal aY,const Quantity_Factor aScale = 1.0) ;

//! Draw a complete image . <br>
//!          Image size must be defined in DPU space> <br>
Standard_EXPORT virtual  void FillAndDrawImage(const Handle(Standard_Transient)& anImageId,const Standard_ShortReal aX,const Standard_ShortReal aY,const Standard_Integer aWidth,const Standard_Integer aHeight,const Standard_Address anArrayOfPixels) ;

//! Fills a line of the Image . <br>
Standard_EXPORT virtual  void FillAndDrawImage(const Handle(Standard_Transient)& anImageId,const Standard_ShortReal aX,const Standard_ShortReal aY,const Standard_Integer anIndexOfLine,const Standard_Integer aWidth,const Standard_Integer aHeight,const Standard_Address anArrayOfPixels) ;

//! Draws a 1 PIXEL point depending of the SetMarkerAttrib() <br>
Standard_EXPORT   void DrawPoint(const Standard_ShortReal X,const Standard_ShortReal Y) ;

//! Draw a segment depending of the SetLineAttrib() attributes. <br>
Standard_EXPORT   void DrawSegment(const Standard_ShortReal X1,const Standard_ShortReal Y1,const Standard_ShortReal X2,const Standard_ShortReal Y2) ;

//! Draw a rectangle. aX,aY is start point <br>
//!      aDX , aDY are horizontal and vertical dimensions <br>
Standard_EXPORT   void DrawRectangle(const Standard_ShortReal aX,const Standard_ShortReal aY,const Standard_ShortReal aDX,const Standard_ShortReal aDY) ;

//! Draw a polyline depending of the SetLineAttrib() attributes. <br>
Standard_EXPORT   void DrawPolyline(const TShort_Array1OfShortReal& aListX,const TShort_Array1OfShortReal& aListY) ;

//! Draw a polygon depending of the SetPolyAttrib() attributes. <br>
Standard_EXPORT   void DrawPolygon(const TShort_Array1OfShortReal& aListX,const TShort_Array1OfShortReal& aListY) ;

//! Draws an Ellipsoid arc of center <X,Y> and Radius <br>
Standard_EXPORT   Standard_Boolean DrawArc(const Standard_ShortReal X,const Standard_ShortReal Y,const Standard_ShortReal anXradius,const Standard_ShortReal anYradius,const Standard_ShortReal aStartAngle = 0.0,const Standard_ShortReal anOpenAngle = 6.283185) ;

//! Draws an filled Ellipsoid arc of center <X,Y> and Radius <br>
Standard_EXPORT   Standard_Boolean DrawPolyArc(const Standard_ShortReal X,const Standard_ShortReal Y,const Standard_ShortReal anXradius,const Standard_ShortReal anYradius,const Standard_ShortReal aStartAngle = 0.0,const Standard_ShortReal anOpenAngle = 6.283185) ;

//! Draws the marker <aMarker> <br>
Standard_EXPORT   void DrawMarker(const Standard_Integer aMarker,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Standard_ShortReal Width,const Standard_ShortReal Height,const Standard_ShortReal Angle = 0.0) ;

//! Draws a text depending of the SetTextAttrib() attributes. <br>
//!  Warning: Coordinates must be defined in DWU space. <br>
Standard_EXPORT   void DrawText(const TCollection_ExtendedString& aText,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Standard_ShortReal anAngle = 0.0,const Aspect_TypeOfText aType = Aspect_TOT_SOLID) ;

//! Draws a text depending of the SetTextAttrib() attributes. <br>
//!  Warning: Coordinates must be defined in DWU space. <br>
Standard_EXPORT   void DrawText(const Standard_CString aText,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Standard_ShortReal anAngle = 0.0,const Aspect_TypeOfText aType = Aspect_TOT_SOLID) ;

//! Draws an framed text depending of the <br>
//! SetTextAttrib() and SetPolyAttrib() attributes. <br>
//!  Warning: Coordinates must be defined in DWU space. <br>
//!          <aMarge> defines the ratio of the space between the <br>
//!          polygon borders and the bounding box of the text and <br>
//!          depending of the height of the text. <br>
Standard_EXPORT   void DrawPolyText(const TCollection_ExtendedString& aText,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Quantity_Ratio aMargin = 0.1,const Standard_ShortReal anAngle = 0.0,const Aspect_TypeOfText aType = Aspect_TOT_SOLID) ;

//! Draws an framed text depending of the <br>
//! SetTextAttrib() and SetPolyAttrib() attributes. <br>
//!  Warning: Coordinates must be defined in DWU space. <br>
//!          <aMarge> defines the ratio of the space between the <br>
//!          polygon borders and the bounding box of the text and <br>
//!          depending of the height of the text. <br>
Standard_EXPORT   void DrawPolyText(const Standard_CString aText,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Quantity_Ratio aMargin = 0.1,const Standard_ShortReal anAngle = 0.0,const Aspect_TypeOfText aType = Aspect_TOT_SOLID) ;


Standard_EXPORT   Handle_PlotMgt_Plotter Plotter() const;


Standard_EXPORT   TCollection_AsciiString PlotFileName() const;


Standard_EXPORT   TCollection_AsciiString DrawingName() const;


Standard_EXPORT   TCollection_AsciiString SpoolDirectory() const;

//! Returns the Available WorkSpace in DWU coordinates <br>
Standard_EXPORT virtual  void WorkSpace(Quantity_Length& Width,Quantity_Length& Height) const;

//! Returns the DWU value depending of the PIXEL value. <br>
Standard_EXPORT virtual  Quantity_Length Convert(const Standard_Integer PV) const;

//! Returns the PIXEL value depending of the DWU value. <br>
Standard_EXPORT virtual  Standard_Integer Convert(const Quantity_Length DV) const;

//! Returns the DWU position depending of the PIXEL position. <br>
Standard_EXPORT virtual  void Convert(const Standard_Integer PX,const Standard_Integer PY,Quantity_Length& DX,Quantity_Length& DY) const;

//! Returns the PIXEL position depending of the DWU position . <br>
Standard_EXPORT virtual  void Convert(const Quantity_Length DX,const Quantity_Length DY,Standard_Integer& PX,Standard_Integer& PY) const;


Standard_EXPORT   void LineAttrib(Standard_Integer& ColorIndex,Standard_Integer& TypeIndex,Standard_Integer& WidthIndex) const;


Standard_EXPORT   void PolyAttrib(Standard_Integer& ColorIndex,Standard_Integer& TileIndex,Standard_Boolean& EdgeFlag) const;


friend class PlotMgt_TextManager;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


Standard_EXPORT PlotMgt_PlotterDriver(const Handle(PlotMgt_Plotter)& aPlotter,const Standard_CString aFileName,const Standard_Boolean fCreateFile = Standard_False);


Standard_EXPORT PlotMgt_PlotterDriver(const Standard_CString aFileName,const Standard_Boolean fCreateFile = Standard_False);


Standard_EXPORT virtual  void CreateDriverColorMap() ;


Standard_EXPORT virtual  void CreateDriverTypeMap() ;


Standard_EXPORT virtual  void CreateDriverWidthMap() ;


Standard_EXPORT virtual  void CreateDriverMarkMap() ;


Standard_EXPORT virtual  void InitializeColorMap(const Handle(Aspect_ColorMap)& aColorMap) ;


Standard_EXPORT virtual  void InitializeTypeMap(const Handle(Aspect_TypeMap)& aTypeMap) ;


Standard_EXPORT virtual  void InitializeWidthMap(const Handle(Aspect_WidthMap)& aWidthMap) ;


Standard_EXPORT virtual  void InitializeFontMap(const Handle(Aspect_FontMap)& aFontMap) ;


Standard_EXPORT virtual  void InitializeMarkMap(const Handle(Aspect_MarkMap)& aFontMap) ;

//! Set the plotter to be used by Spool() method. <br>
//! Fail if Plotter is already defined <br>
Standard_EXPORT   void SetPlotter(const Handle(PlotMgt_Plotter)& aPlotter) ;

//! retrieve current line attributes <br>
Standard_EXPORT virtual  void PlotLineAttrib(const Standard_Integer ColorIndex,const Standard_Integer TypeIndex,const Standard_Integer WidthIndex) ;

//! retrieve current poly attributes <br>
Standard_EXPORT virtual  void PlotPolyAttrib(const Standard_Integer ColorIndex,const Standard_Integer TileIndex,const Standard_Boolean DrawEdge) ;


Standard_EXPORT virtual  Standard_Boolean PlotPoint(const Standard_ShortReal X,const Standard_ShortReal Y) ;


Standard_EXPORT virtual  Standard_Boolean PlotSegment(const Standard_ShortReal X1,const Standard_ShortReal Y1,const Standard_ShortReal X2,const Standard_ShortReal Y2) ;


Standard_EXPORT virtual  Standard_Boolean PlotRectangle(const Standard_ShortReal aX,const Standard_ShortReal aY,const Standard_ShortReal aDX,const Standard_ShortReal aDY,const Standard_ShortReal aAngle = 0.0) ;


Standard_EXPORT virtual  Standard_Boolean PlotPolyline(const Standard_Address xArray,const Standard_Address yArray,const Standard_Address nPts,const Standard_Integer nParts) ;


Standard_EXPORT virtual  Standard_Boolean PlotPolygon(const Standard_Address xArray,const Standard_Address yArray,const Standard_Address nPts,const Standard_Integer nParts) ;


Standard_EXPORT virtual  Standard_Boolean PlotArc(const Standard_ShortReal X,const Standard_ShortReal Y,const Standard_ShortReal anXradius,const Standard_ShortReal anYradius,const Standard_ShortReal sAngle,const Standard_ShortReal oAngle) ;


Standard_EXPORT virtual  Standard_Boolean PlotPolyArc(const Standard_ShortReal X,const Standard_ShortReal Y,const Standard_ShortReal anXradius,const Standard_ShortReal anYradius,const Standard_ShortReal sAngle,const Standard_ShortReal oAngle) ;


Standard_EXPORT virtual  Standard_Boolean PlotMarker(const Standard_Integer aMarker,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Standard_ShortReal Width,const Standard_ShortReal Height,const Standard_ShortReal Angle) ;


Standard_EXPORT virtual  Standard_Boolean PlotText(const TCollection_ExtendedString& aText,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Standard_ShortReal anAngle,const Aspect_TypeOfText aType) ;


Standard_EXPORT virtual  Standard_Boolean PlotText(const Standard_CString aText,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Standard_ShortReal anAngle,const Aspect_TypeOfText aType) ;


Standard_EXPORT virtual  Standard_Boolean PlotPolyText(const TCollection_ExtendedString& aText,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Quantity_Ratio aMargin,const Standard_ShortReal anAngle,const Aspect_TypeOfText aType) ;


Standard_EXPORT virtual  Standard_Boolean PlotPolyText(const Standard_CString aText,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Quantity_Ratio aMargin,const Standard_ShortReal anAngle,const Aspect_TypeOfText aType) ;


Standard_EXPORT virtual  Standard_Boolean PlotImage(const Standard_ShortReal aX,const Standard_ShortReal aY,const Standard_ShortReal aWidth,const Standard_ShortReal aHeight,const Standard_ShortReal aScale,const Standard_CString anImageFile,const Standard_Address anArrayOfPixels,const Standard_Integer aLineIndex = -1) ;


Standard_EXPORT   Aspect_FStream Cout() const;

//! Should be called from PlotMgt_TextManager::Curveto() <br>
//!         method to check if the driver is capable to draw curves. <br>
Standard_EXPORT virtual  Standard_Boolean DrawCurveCapable() const;


 // Fields PROTECTED
 //
Standard_Real myPixelSize;
TCollection_AsciiString myDrawingName;
TCollection_AsciiString myFileName;
Standard_ShortReal myWidth;
Standard_ShortReal myHeight;
Standard_ShortReal myPaperMargin;
Aspect_TypeOfColorSpace myTypeOfColorSpace;
Standard_Integer myColorIndex;
Standard_Integer myTypeIndex;
Standard_Integer myWidthIndex;
Standard_Integer myFontIndex;
Standard_Integer myLineColorIndex;
Standard_Integer myLineTypeIndex;
Standard_Integer myLineWidthIndex;
Standard_Integer myPolyColorIndex;
Standard_Integer myPolyTileIndex;
Standard_Boolean myPolyEdgeFlag;
Standard_Integer myMarkerColorIndex;
Standard_Integer myMarkerWidthIndex;
Standard_Boolean myMarkerFillFlag;
Standard_Integer myTextColorIndex;
Standard_Integer myTextFontIndex;
Standard_Real myTextHScale;
Standard_Real myTextWScale;
Standard_Real myTextSlant;
Standard_Real myTextMinHeight;
Standard_Boolean myTextIsUnderlined;
Standard_Boolean myCapsHeight;
Aspect_TypeOfPrimitive myPrimitiveType;
Standard_Integer myPrimitiveLength;
TShort_Array1OfShortReal myPrimitiveX;
TShort_Array1OfShortReal myPrimitiveY;
Handle_PlotMgt_HListOfMFTFonts myMFTFonts;
Handle_PlotMgt_HListOfMFTSizes myMFTSizes;
Handle_PlotMgt_TextManager myTextManager;
Handle_Aspect_ColorMap myDriverColorMap;
Handle_Aspect_TypeMap myDriverTypeMap;
Handle_Aspect_WidthMap myDriverWidthMap;
Handle_Aspect_MarkMap myDriverMarkMap;


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT virtual  Standard_ShortReal MapX(const Standard_ShortReal aShortReal) const;


Standard_EXPORT virtual  Standard_ShortReal MapY(const Standard_ShortReal aShortReal) const;


 // Fields PRIVATE
 //
Aspect_FStream myFStream;
Handle_PlotMgt_Plotter myPlotter;
Standard_Boolean myPlotterIsDefined;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
