// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ProjLib_ProjectOnSurface_HeaderFile
#define _ProjLib_ProjectOnSurface_HeaderFile

#ifndef _Handle_Adaptor3d_HCurve_HeaderFile
#include <Handle_Adaptor3d_HCurve.hxx>
#endif
#ifndef _Handle_Adaptor3d_HSurface_HeaderFile
#include <Handle_Adaptor3d_HSurface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_BSplineCurve_HeaderFile
#include <Handle_Geom_BSplineCurve.hxx>
#endif
class Adaptor3d_HCurve;
class Adaptor3d_HSurface;
class Geom_BSplineCurve;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class ProjLib_ProjectOnSurface  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//!  Create an empty projector. <br>
Standard_EXPORT ProjLib_ProjectOnSurface();

//! Create a projector normaly to the surface <S>. <br>
Standard_EXPORT ProjLib_ProjectOnSurface(const Handle(Adaptor3d_HSurface)& S);


Standard_EXPORT virtual  void Delete() ;
Standard_EXPORT virtual ~ProjLib_ProjectOnSurface(){Delete() ; }

//! Set the Surface to <S>. <br>
//!          To compute the projection, you have to Load the Curve. <br>
Standard_EXPORT   void Load(const Handle(Adaptor3d_HSurface)& S) ;

//! Compute the projection of the curve <C> on the Surface. <br>
Standard_EXPORT   void Load(const Handle(Adaptor3d_HCurve)& C,const Standard_Real Tolerance) ;


Standard_EXPORT   Standard_Boolean IsDone() const;


Standard_EXPORT   Handle_Geom_BSplineCurve BSpline() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Adaptor3d_HCurve myCurve;
Handle_Adaptor3d_HSurface mySurface;
Standard_Real myTolerance;
Standard_Boolean myIsDone;
Handle_Geom_BSplineCurve myResult;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
