// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Prs3d_LineAspect_HeaderFile
#define _Prs3d_LineAspect_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Prs3d_LineAspect_HeaderFile
#include <Handle_Prs3d_LineAspect.hxx>
#endif

#ifndef _Handle_Graphic3d_AspectLine3d_HeaderFile
#include <Handle_Graphic3d_AspectLine3d.hxx>
#endif
#ifndef _Prs3d_BasicAspect_HeaderFile
#include <Prs3d_BasicAspect.hxx>
#endif
#ifndef _Quantity_NameOfColor_HeaderFile
#include <Quantity_NameOfColor.hxx>
#endif
#ifndef _Aspect_TypeOfLine_HeaderFile
#include <Aspect_TypeOfLine.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Graphic3d_AspectLine3d;
class Quantity_Color;


//! A framework for defining how a line will be displayed <br>
//! in a presentation. Aspects of line display include <br>
//! width, color and type of line. <br>
//! The definition set by this class is then passed to the <br>
//! attribute manager Prs3d_Drawer. <br>
//! Any object which requires a value for line aspect as <br>
//! an argument may then be given the attribute manager <br>
//! as a substitute argument in the form of a field such as myDrawer for example. <br>
class Prs3d_LineAspect : public Prs3d_BasicAspect {

public:
 // Methods PUBLIC
 // 

//! Constructs a framework for line aspect defined by <br>
//! -   the color aColor <br>
//! -   the type of line aType and <br>
//! -   the line thickness aWidth. <br>
//!   Type of line refers to whether the line is solid or dotted, for example. <br>
Standard_EXPORT Prs3d_LineAspect(const Quantity_NameOfColor aColor,const Aspect_TypeOfLine aType,const Standard_Real aWidth);


Standard_EXPORT Prs3d_LineAspect(const Quantity_Color& aColor,const Aspect_TypeOfLine aType,const Standard_Real aWidth);


Standard_EXPORT   void SetColor(const Quantity_Color& aColor) ;

//! Sets the line color defined at the time of construction. <br>
//!          Default value: Quantity_NOC_YELLOW <br>
Standard_EXPORT   void SetColor(const Quantity_NameOfColor aColor) ;

//! Sets the type of line defined at the time of construction. <br>
//! This could, for example, be solid, dotted or made up of dashes. <br>
//!          Default value: Aspect_TOL_SOLID <br>
Standard_EXPORT   void SetTypeOfLine(const Aspect_TypeOfLine aType) ;

//! Sets the line width defined at the time of construction. <br>
//!          Default value: 1. <br>
Standard_EXPORT   void SetWidth(const Standard_Real aWidth) ;

//! Returns the line aspect. This is defined as the set of <br>
//! color, type and thickness attributes. <br>
Standard_EXPORT   Handle_Graphic3d_AspectLine3d Aspect() const;


Standard_EXPORT virtual  void Print(Standard_OStream& s) const;
//Standard_EXPORT ~Prs3d_LineAspect();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Graphic3d_AspectLine3d myAspect;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
