// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Prs3d_Text_HeaderFile
#define _Prs3d_Text_HeaderFile

#ifndef _Prs3d_Root_HeaderFile
#include <Prs3d_Root.hxx>
#endif
#ifndef _Handle_Prs3d_Presentation_HeaderFile
#include <Handle_Prs3d_Presentation.hxx>
#endif
#ifndef _Handle_Prs3d_Drawer_HeaderFile
#include <Handle_Prs3d_Drawer.hxx>
#endif
#ifndef _Handle_Prs3d_TextAspect_HeaderFile
#include <Handle_Prs3d_TextAspect.hxx>
#endif
class Prs3d_Presentation;
class Prs3d_Drawer;
class TCollection_ExtendedString;
class gp_Pnt;
class Prs3d_TextAspect;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A framework to define the display of texts. <br>
class Prs3d_Text  : public Prs3d_Root {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Defines the display of the text aText at the point AttachmentPoint. <br>
//! The drawer aDrawer specifies the display attributes which texts will have. <br>
//! The presentation object aPresentation stores the <br>
//! information defined in this framework. <br>
//! static void Draw (const Handle(Prs3d_Presentation)& <br>
//! aPresentation, const Handle(Prs3d_TextAspect)& <br>
//! anAspect, const TCollection_ExtendedString& aText, <br>
//! const gp_Pnt& AttachmentPoint); <br>
Standard_EXPORT static  void Draw(const Handle(Prs3d_Presentation)& aPresentation,const Handle(Prs3d_Drawer)& aDrawer,const TCollection_ExtendedString& aText,const gp_Pnt& AttachmentPoint) ;

//! Defines the display of the text aText at the point <br>
//! AttachmentPoint. <br>
//! The text aspect object anAspect specifies the display <br>
//! attributes which texts will have. <br>
//! The presentation object aPresentation stores the <br>
//! information defined in this framework. <br>
//! This syntax could be used if you had not already <br>
//! defined text display attributes in a drawer or if you <br>
//! wanted to exceptionally overide the definition <br>
//! provided in your drawer. <br>
Standard_EXPORT static  void Draw(const Handle(Prs3d_Presentation)& aPresentation,const Handle(Prs3d_TextAspect)& anAspect,const TCollection_ExtendedString& aText,const gp_Pnt& AttachmentPoint) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
