// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDataStd_RealArray_HeaderFile
#define _TDataStd_RealArray_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TDataStd_RealArray_HeaderFile
#include <Handle_TDataStd_RealArray.hxx>
#endif

#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _TDF_Attribute_HeaderFile
#include <TDF_Attribute.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TDF_Attribute_HeaderFile
#include <Handle_TDF_Attribute.hxx>
#endif
#ifndef _Handle_TDF_RelocationTable_HeaderFile
#include <Handle_TDF_RelocationTable.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TColStd_HArray1OfReal;
class Standard_GUID;
class TDF_Label;
class TDF_Attribute;
class TDF_RelocationTable;


//! A framework for an attribute composed of a real number array. <br>
class TDataStd_RealArray : public TDF_Attribute {

public:
 // Methods PUBLIC
 // 

//! class methods <br>
//!          ============= <br>//! Returns the GUID for arrays of reals. <br>
Standard_EXPORT static const Standard_GUID& GetID() ;

//! Finds or creates an attribute of arrays of real <br>
//! numbers with the lower boundary lower and the <br>
//! upper boundary upper, on the label label. <br>
Standard_EXPORT static  Handle_TDataStd_RealArray Set(const TDF_Label& label,const Standard_Integer lower,const Standard_Integer upper) ;

//! Initialize the inner array with bounds from <lower> to <upper> <br>
Standard_EXPORT   void Init(const Standard_Integer lower,const Standard_Integer upper) ;

//! Sets  the   <Index>th  element  of   the  array to <Value> <br>
Standard_EXPORT   void SetValue(const Standard_Integer Index,const Standard_Real Value) ;

//! Return the value of  the  <Index>th element of the array <br>
Standard_EXPORT   Standard_Real Value(const Standard_Integer Index) const;
  Standard_Real operator ()(const Standard_Integer Index) const
{
  return Value(Index);
}


//!  Returns the lower boundary of the array. <br>
Standard_EXPORT   Standard_Integer Lower() const;

//! Returns the upper boundary of the array. <br>
Standard_EXPORT   Standard_Integer Upper() const;

//! Returns the number of elements of the array of reals <br>
//!    in terms of the number of elements it contains. <br>
Standard_EXPORT   Standard_Integer Length() const;

//! Sets the inner array <myValue> of the RealArray attribute <br>
//! to <newArray>. If value of <newArray> differs from <myValue>, <br>
//! Backup performed and myValue refers to new instance of HArray1OfReal <br>
//! that holds <newArray> values <br>
Standard_EXPORT   void ChangeArray(const Handle(TColStd_HArray1OfReal)& newArray) ;

//! Returns the handle of this array of reals. <br>
Standard_EXPORT   Handle_TColStd_HArray1OfReal Array() const;


Standard_EXPORT TDataStd_RealArray();


Standard_EXPORT  const Standard_GUID& ID() const;


Standard_EXPORT   void Restore(const Handle(TDF_Attribute)& With) ;


Standard_EXPORT   Handle_TDF_Attribute NewEmpty() const;

//! Note. Uses inside ChangeArray() method <br>
Standard_EXPORT   void Paste(const Handle(TDF_Attribute)& Into,const Handle(TDF_RelocationTable)& RT) const;


Standard_EXPORT virtual  Standard_OStream& Dump(Standard_OStream& anOS) const;
//Standard_EXPORT ~TDataStd_RealArray();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TColStd_HArray1OfReal myValue;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
