// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopAbs_HeaderFile
#define _TopAbs_HeaderFile

#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class TopAbs  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Compose  the Orientation    <Or1>  and  <Or2>.    This <br>
//!          composition is not symmetric (if  you switch <Or1> and <br>
//!          <Or2> the result  is different). It assumes that <Or1> <br>
//!          is the Orientation of a Shape S1 containing a Shape S2 <br>
//!          of Orientation   Or2.  The result    is the  cumulated <br>
//!          orientation of S2 in S1.  The composition law is : <br>
//! <br>
//!             \ Or2     FORWARD  REVERSED INTERNAL EXTERNAL <br>
//!           Or1       ------------------------------------- <br>
//!           FORWARD   | FORWARD  REVERSED INTERNAL EXTERNAL <br>
//!                     | <br>
//!           REVERSED  | REVERSED FORWARD  EXTERNAL INTERNAL <br>
//!                     | <br>
//!           INTERNAL  | INTERNAL INTERNAL INTERNAL INTERNAL <br>
//!                     | <br>
//!           EXTERNAL  | EXTERNAL EXTERNAL EXTERNAL EXTERNAL <br>
//!     Note: The top corner in the table is the most important <br>
//! for the purposes of Open CASCADE topology and shape sharing. <br>
Standard_EXPORT static  TopAbs_Orientation Compose(const TopAbs_Orientation Or1,const TopAbs_Orientation Or2) ;

//! xchanges the interior/exterior status of the two <br>
//! sides. This is what happens when the sense of <br>
//! direction is reversed. The following rules apply: <br>
//! <br>
//!          FORWARD          REVERSED <br>
//!          REVERSED         FORWARD <br>
//!          INTERNAL         INTERNAL <br>
//!          EXTERNAL         EXTERNAL <br>
//! <br>
//!          Reverse exchange the material sides. <br>
//! <br>
Standard_EXPORT static  TopAbs_Orientation Reverse(const TopAbs_Orientation Or) ;

//! Reverses the interior/exterior status of each side of <br>
//! the object. So, to take the complement of an object <br>
//! means to reverse the interior/exterior status of its <br>
//! boundary, i.e. inside becomes outside. <br>
//! The method returns the complementary orientation, <br>
//! following the rules in the table below: <br>
//!          FORWARD          REVERSED <br>
//!          REVERSED         FORWARD <br>
//!          INTERNAL         EXTERNAL <br>
//!          EXTERNAL         INTERNAL <br>
//! <br>
//!          Complement  complements   the  material  side.  Inside <br>
//!          becomes outside. <br>
//! <br>
Standard_EXPORT static  TopAbs_Orientation Complement(const TopAbs_Orientation Or) ;

//! Prints the name  of Shape  <SEq>  as  a String  on the <br>
//!          Stream <S> and returns <S>. <br>
//! <br>
Standard_EXPORT static  Standard_OStream& Print(const TopAbs_ShapeEnum SE,Standard_OStream& S) ;

//! Prints the name of the Orientation <Or> as a String on <br>
//!          the Stream <S> and returns <S>. <br>
//! <br>
Standard_EXPORT static  Standard_OStream& Print(const TopAbs_Orientation Or,Standard_OStream& S) ;

//! Prints the name of the State <St> as a String on <br>
//!          the Stream <S> and returns <S>. <br>
//! <br>
Standard_EXPORT static  Standard_OStream& Print(const TopAbs_State St,Standard_OStream& S) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
