// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopOpeBRep_ShapeIntersector_HeaderFile
#define _TopOpeBRep_ShapeIntersector_HeaderFile

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Handle_TopOpeBRepTool_HBoxTool_HeaderFile
#include <Handle_TopOpeBRepTool_HBoxTool.hxx>
#endif
#ifndef _TopOpeBRepTool_ShapeExplorer_HeaderFile
#include <TopOpeBRepTool_ShapeExplorer.hxx>
#endif
#ifndef _TopOpeBRep_ShapeScanner_HeaderFile
#include <TopOpeBRep_ShapeScanner.hxx>
#endif
#ifndef _TopOpeBRep_FacesIntersector_HeaderFile
#include <TopOpeBRep_FacesIntersector.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopOpeBRep_EdgesIntersector_HeaderFile
#include <TopOpeBRep_EdgesIntersector.hxx>
#endif
#ifndef _TopOpeBRep_FaceEdgeIntersector_HeaderFile
#include <TopOpeBRep_FaceEdgeIntersector.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TopOpeBRepTool_HBoxTool;
class TopoDS_Shape;
class TopoDS_Face;
class TopOpeBRep_FacesIntersector;
class TopOpeBRep_EdgesIntersector;
class TopOpeBRep_FaceEdgeIntersector;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Intersect two shapes. <br>
//! <br>
//!          A GeomShape is a  shape with a geometric domain, i.e. <br>
//!          a Face or an Edge. <br>
//! <br>
//!          The purpose   of  the  ShapeIntersector is   to  find <br>
//!          couples  of  intersecting   GeomShape  in  two Shapes <br>
//!          (which can   be  any kind of  topologies  : Compound, <br>
//!          Solid, Shell, etc... ) <br>
//! <br>
//!          It  is in charge  of  exploration  of the shapes  and <br>
//!          rejection. For this it is provided with two tools : <br>
//! <br>
//!            - ShapeExplorer from TopOpeBRepTool. <br>
//!            - ShapeScanner from TopOpeBRep which implements bounding boxes. <br>
class TopOpeBRep_ShapeIntersector  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT TopOpeBRep_ShapeIntersector();

//! Initialize the intersection of shapes S1,S2. <br>
Standard_EXPORT   void InitIntersection(const TopoDS_Shape& S1,const TopoDS_Shape& S2) ;

//! Initialize the intersection of shapes S1,S2. <br>
Standard_EXPORT   void InitIntersection(const TopoDS_Shape& S1,const TopoDS_Shape& S2,const TopoDS_Face& F1,const TopoDS_Face& F2) ;

//! return  the shape  <Index> ( = 1 or 2) given to <br>
//!          InitIntersection(). <br>
//!          Index = 1 will return S1, Index = 2 will return S2. <br>
Standard_EXPORT  const TopoDS_Shape& Shape(const Standard_Integer Index) const;

//! returns True if there are more intersection <br>
//!          between two the shapes. <br>
Standard_EXPORT   Standard_Boolean MoreIntersection() const;

//! search for the next intersection between the two shapes. <br>
Standard_EXPORT   void NextIntersection() ;

//! return the current intersection of two Faces. <br>
Standard_EXPORT   TopOpeBRep_FacesIntersector& ChangeFacesIntersector() ;

//! return the current intersection of two Edges. <br>
Standard_EXPORT   TopOpeBRep_EdgesIntersector& ChangeEdgesIntersector() ;

//! return the current intersection of a Face and an Edge. <br>
Standard_EXPORT   TopOpeBRep_FaceEdgeIntersector& ChangeFaceEdgeIntersector() ;

//! return  geometric  shape <Index> ( = 1 or 2 )  of <br>
//!          current intersection. <br>
Standard_EXPORT  const TopoDS_Shape& CurrentGeomShape(const Standard_Integer Index) const;

//! return  MAX of intersection tolerances with <br>
//!          which FacesIntersector from TopOpeBRep was working. <br>
Standard_EXPORT   void GetTolerances(Standard_Real& tol1,Standard_Real& tol2) const;


Standard_EXPORT   void DumpCurrent(const Standard_Integer K) const;


Standard_EXPORT   Standard_Integer Index(const Standard_Integer K) const;


Standard_EXPORT   void RejectedFaces(const TopoDS_Shape& anObj,const TopoDS_Shape& aReference,TopTools_ListOfShape& aListOfShape) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Reset() ;


Standard_EXPORT   void Init(const TopoDS_Shape& S1,const TopoDS_Shape& S2) ;


Standard_EXPORT   void SetIntersectionDone() ;


Standard_EXPORT   void InitFFIntersection() ;


Standard_EXPORT   void FindFFIntersection() ;


Standard_EXPORT   Standard_Boolean MoreFFCouple() const;


Standard_EXPORT   void NextFFCouple() ;


Standard_EXPORT   void InitEEFFIntersection() ;


Standard_EXPORT   void FindEEFFIntersection() ;


Standard_EXPORT   Standard_Boolean MoreEEFFCouple() const;


Standard_EXPORT   void NextEEFFCouple() ;


Standard_EXPORT   void InitFEIntersection() ;


Standard_EXPORT   void FindFEIntersection() ;


Standard_EXPORT   Standard_Boolean MoreFECouple() const;


Standard_EXPORT   void NextFECouple() ;


Standard_EXPORT   void InitEFIntersection() ;


Standard_EXPORT   void FindEFIntersection() ;


Standard_EXPORT   Standard_Boolean MoreEFCouple() const;


Standard_EXPORT   void NextEFCouple() ;


Standard_EXPORT   void InitEEIntersection() ;


Standard_EXPORT   void FindEEIntersection() ;


Standard_EXPORT   Standard_Boolean MoreEECouple() const;


Standard_EXPORT   void NextEECouple() ;


 // Fields PRIVATE
 //
TopoDS_Shape myShape1;
TopoDS_Shape myShape2;
Handle_TopOpeBRepTool_HBoxTool myHBoxTool;
TopOpeBRepTool_ShapeExplorer myFaceExplorer;
TopOpeBRep_ShapeScanner myFaceScanner;
TopOpeBRep_FacesIntersector myFFIntersector;
Standard_Boolean myFFSameDomain;
TopOpeBRepTool_ShapeExplorer myEdgeExplorer;
TopOpeBRep_ShapeScanner myEdgeScanner;
TopOpeBRep_EdgesIntersector myEEIntersector;
TopOpeBRep_FaceEdgeIntersector myFEIntersector;
TopoDS_Face myEEFace1;
TopoDS_Face myEEFace2;
Standard_Boolean myIntersectionDone;
Standard_Real myTol1;
Standard_Real myTol2;
Standard_Boolean myFFDone;
Standard_Boolean myEEFFDone;
Standard_Boolean myEFDone;
Standard_Boolean myFEDone;
Standard_Boolean myEEDone;
Standard_Boolean myFFInit;
Standard_Boolean myEEFFInit;
Standard_Boolean myEFInit;
Standard_Boolean myFEInit;
Standard_Boolean myEEInit;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
