// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Units_UnitsSystem_HeaderFile
#define _Units_UnitsSystem_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Units_UnitsSystem_HeaderFile
#include <Handle_Units_UnitsSystem.hxx>
#endif

#ifndef _Handle_Units_QuantitiesSequence_HeaderFile
#include <Handle_Units_QuantitiesSequence.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfInteger_HeaderFile
#include <Handle_TColStd_HSequenceOfInteger.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Units_QuantitiesSequence;
class TColStd_HSequenceOfInteger;
class Units_NoSuchUnit;
class Units_NoSuchType;
class TCollection_AsciiString;


//! This class  allows  the  user  to  define his  own <br>
//!          system of units. <br>
class Units_UnitsSystem : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Returns an instance of UnitsSystem initialized to the <br>
//!          S.I. units system. <br>
Standard_EXPORT Units_UnitsSystem();

//! Returns an instance of UnitsSystem initialized to the <br>
//!          S.I. units system upgraded by the base system units decription <br>
//!	 	file. <br>
//!          Attempts to find the four following files: <br>
//!          $CSF_`aName`Defaults/.aName <br>
//!          $CSF_`aName`SiteDefaults/.aName <br>
//!          $CSF_`aName`GroupDefaults/.aName <br>
//!          $CSF_`aName`UserDefaults/.aName <br>
//!		See : Resource_Manager for the description of this file. <br>
Standard_EXPORT Units_UnitsSystem(const Standard_CString aName,const Standard_Boolean Verbose = Standard_False);

//! Returns the sequence of refined quantities. <br>
Standard_EXPORT   Handle_Units_QuantitiesSequence QuantitiesSequence() const;

//! Returns a sequence of integer in correspondance with <br>
//!          the sequence of quantities, which indicates, for each <br>
//!          redefined quantity, the index into the sequence of <br>
//!          units, of the active unit. <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfInteger ActiveUnitsSequence() const;

//! Specifies for <aquantity> the unit <aunit> used. <br>
Standard_EXPORT   void Specify(const Standard_CString aquantity,const Standard_CString aunit) ;

//! Removes for <aquantity> the unit <aunit> used. <br>
Standard_EXPORT   void Remove(const Standard_CString aquantity,const Standard_CString aunit) ;

//! Specifies for <aquantity> the unit <aunit> used. <br>
Standard_EXPORT   void Activate(const Standard_CString aquantity,const Standard_CString aunit) ;

//! Activates the first unit of all defined system quantities <br>
Standard_EXPORT   void Activates() ;

//! Returns for <aquantity> the active unit. <br>
Standard_EXPORT   TCollection_AsciiString ActiveUnit(const Standard_CString aquantity) const;

//! Converts a real value <avalue> from the unit <aunit> <br>
//!          belonging to the physical dimensions <aquantity> to <br>
//!          the corresponding unit of the user system. <br>
Standard_EXPORT   Standard_Real ConvertValueToUserSystem(const Standard_CString aquantity,const Standard_Real avalue,const Standard_CString aunit) const;

//! Converts the real value <avalue> from the S.I. system <br>
//!          of units to the user system of units. <aquantity> is <br>
//!          the physical dimensions of the measurement. <br>
Standard_EXPORT   Standard_Real ConvertSIValueToUserSystem(const Standard_CString aquantity,const Standard_Real avalue) const;

//! Converts the real value <avalue> from the user system <br>
//!          of units to the S.I. system of units. <aquantity> is <br>
//!          the physical dimensions of the measurement. <br>
Standard_EXPORT   Standard_Real ConvertUserSystemValueToSI(const Standard_CString aquantity,const Standard_Real avalue) const;


Standard_EXPORT   void Dump() const;

//! Returns TRUE if no units has been defined in the system. <br>
Standard_EXPORT   Standard_Boolean IsEmpty() const;
//Standard_EXPORT ~Units_UnitsSystem();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Units_QuantitiesSequence thequantitiessequence;
Handle_TColStd_HSequenceOfInteger theactiveunitssequence;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
