// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Vrml_ShapeHints_HeaderFile
#define _Vrml_ShapeHints_HeaderFile

#ifndef _Vrml_VertexOrdering_HeaderFile
#include <Vrml_VertexOrdering.hxx>
#endif
#ifndef _Vrml_ShapeType_HeaderFile
#include <Vrml_ShapeType.hxx>
#endif
#ifndef _Vrml_FaceType_HeaderFile
#include <Vrml_FaceType.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! defines a ShapeHints node of VRML specifying properties of geometry and its appearance. <br>
//!  The ShapeHints node indicates that IndexedFaceSets are solid, contain ordered vertices, or <br>
//!  contain convex faces. <br>
//!  These hints allow VRML implementations to optimize certain rendering features. <br>
//!  Optimizations that may be performed include enabling back-face culling and disabling <br>
//!  two-sided lighting. For example, if an object is solid and has ordered vertices, an <br>
//!  implementation may turn on backface culling and turn off two-sided lighting. To ensure <br>
//!  that an IndexedFaceSet can be viewed from either direction, set shapeType to be <br>
//!  UNKNOWN_SHAPE_TYPE. <br>
//!  If you know that your shapes are closed and will alwsys be viewed from the outside, set <br>
//!  vertexOrdering to be either CLOCKWISE or COUNTERCLOCKWISE (depending on <br>
//!  how you built your object), and set shapeType to be SOLID. Placing this near the top of <br>
//!  your VRML file will allow the scene to be rendered much faster. <br>
//!  The ShapeHints node also affects how default normals are generated. When an <br>
//!  IndexedFaceSet has to generate default normals, it uses the creaseAngle field to determine <br>
//!  which edges should be smoothly shaded and which ones should have a sharp crease. The <br>
//!  crease angle is the angle between surface normals on adjacent polygons. For example, a <br>
//!  crease angle of .5 radians (the default value) means that an edge between two adjacent <br>
//!  polygonal faces will be smooth shaded if the normals to the two faces form an angle that is <br>
//!  less than .5 radians (about 30 degrees). Otherwise, it will be faceted. <br>
class Vrml_ShapeHints  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Vrml_ShapeHints(const Vrml_VertexOrdering aVertexOrdering = Vrml_UNKNOWN_ORDERING,const Vrml_ShapeType aShapeType = Vrml_UNKNOWN_SHAPE_TYPE,const Vrml_FaceType aFaceType = Vrml_CONVEX,const Standard_Real aAngle = 0.5);


Standard_EXPORT   void SetVertexOrdering(const Vrml_VertexOrdering aVertexOrdering) ;


Standard_EXPORT   Vrml_VertexOrdering VertexOrdering() const;


Standard_EXPORT   void SetShapeType(const Vrml_ShapeType aShapeType) ;


Standard_EXPORT   Vrml_ShapeType ShapeType() const;


Standard_EXPORT   void SetFaceType(const Vrml_FaceType aFaceType) ;


Standard_EXPORT   Vrml_FaceType FaceType() const;


Standard_EXPORT   void SetAngle(const Standard_Real aAngle) ;


Standard_EXPORT   Standard_Real Angle() const;


Standard_EXPORT   Standard_OStream& Print(Standard_OStream& anOStream) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Vrml_VertexOrdering myVertexOrdering;
Vrml_ShapeType myShapeType;
Vrml_FaceType myFaceType;
Standard_Real myAngle;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
