// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _WNT_IconBox_HeaderFile
#define _WNT_IconBox_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_WNT_IconBox_HeaderFile
#include <Handle_WNT_IconBox.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Aspect_Handle_HeaderFile
#include <Aspect_Handle.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _WNT_Window_HeaderFile
#include <WNT_Window.hxx>
#endif
#ifndef _Handle_WNT_GraphicDevice_HeaderFile
#include <Handle_WNT_GraphicDevice.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _WNT_Dword_HeaderFile
#include <WNT_Dword.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Quantity_NameOfColor_HeaderFile
#include <Quantity_NameOfColor.hxx>
#endif
#ifndef _Handle_WNT_Window_HeaderFile
#include <Handle_WNT_Window.hxx>
#endif
#ifndef _WNT_Long_HeaderFile
#include <WNT_Long.hxx>
#endif
#ifndef _WNT_Uint_HeaderFile
#include <WNT_Uint.hxx>
#endif
class Aspect_WindowDefinitionError;
class Aspect_WindowError;
class WNT_GraphicDevice;
class WNT_Window;


//! This class defines a Windows NT icon box <br>
class WNT_IconBox : public WNT_Window {

public:
 // Methods PUBLIC
 // 

//! Creates an IconBox defined by his Center in DSU. <br>
//!	    ALL Icons are loaded from the Icon File Directory Name: <br>
//!	    "[$SYMBOL]xxxxxxx[.ifd]" <br>
//!  Warning: Raises if the Position is out of the Screen Space <br>
//!	    or the Icon File Directory Name don't exist <br>
Standard_EXPORT WNT_IconBox(const Handle(WNT_GraphicDevice)& aDevice,const Standard_CString aName,const WNT_Dword& aStyle = 0,const Standard_Real Xc = 0.5,const Standard_Real Yc = 0.5,const Quantity_NameOfColor aBkColor = Quantity_NOC_MATRAGRAY);

//! Loads Icon Box from an Other Icon File Directory Name <br>
//!          and returns the loaded icons number. <br>
//!  Warning: The Icons previously loaded are NOT cleared. <br>
Standard_EXPORT   Standard_Integer LoadIcons(const Standard_CString Name) ;

//! Shows Icon Box to the screen <br>
//!  Warning: The Icon Box is displayed at the centered position <br>
//!	    specified at the creation time and the size depend <br>
//!	    of the Icon number really loaded inside. <br>
Standard_EXPORT   void Show() const;

//! Unloads All previously loaded Icons in the IconBox <br>
//!          and returns the unloaded icons number. <br>
Standard_EXPORT   Standard_Integer UnloadIcons(const Standard_CString Name) ;

//! Destroies the IconBox <br>
Standard_EXPORT virtual  void Destroy() ;
~WNT_IconBox()
{
  Destroy();
}


//! Adds an Icon of Size aWidth,aHeight given in PIXEL <br>
//!          to the Icon Box from a FULL Existing Window <br>
//!  NOTE that if aWidth or aHeight is 0 the default icon size is taken. <br>
Standard_EXPORT   void AddIcon(const Handle(WNT_Window)& W,const Standard_CString Name,const Standard_Integer aWidth = 0,const Standard_Integer aHeight = 0) ;

//!  Save all new created Icons as iconname.xwd file in the user <br>
//!      directory and returns the saved icons number. <br>
Standard_EXPORT   Standard_Integer SaveIcons() const;

//! Sets dimensions for icons which are visible in the box. <br>
Standard_EXPORT   void SetDim(const Standard_Integer aWidth,const Standard_Integer aHeight) ;

//! Returns the Number of Icons loaded in the Icon Box. <br>
Standard_EXPORT   Standard_Integer IconNumber() const;

//! Returns the Name of the N ime Icon <br>
//!  Warning: Raises if Index if out of range depending of the <br>
//!	    Number of Loaded Icons. <br>
Standard_EXPORT   Standard_CString IconName(const Standard_Integer Index) const;

//! Returns the Pixmap Size attached to the Icon Name <br>
//!  Warning: May return FALSE if Icon doesn't exist in the IconBox. <br>
Standard_EXPORT   Standard_Boolean IconSize(const Standard_CString Name,Standard_Integer& Width,Standard_Integer& Height) const;

//! Returns the Pixmap attached to the Icon Name <br>
//!  Warning: May return 0 if Icon doesn't exist in the IconBox. <br>
Standard_EXPORT   Aspect_Handle IconPixmap(const Standard_CString Name) const;

//! Returns the Centered part of the Pixmap of required Size <br>
//!	    attached to the Icon Name <br>
//!  Warning: May return 0 if Icon doesn't exist in the IconBox. <br>
Standard_EXPORT   Aspect_Handle IconPixmap(const Standard_CString Name,const Standard_Integer Width,const Standard_Integer Height) const;

//! routine to process events sent to the icon box <br>
Standard_EXPORT   WNT_Long HandleEvent(const Aspect_Handle& hwnd,const WNT_Uint& uMsg,const WNT_Dword& wParam,const WNT_Dword& lParam) ;




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Standard_Integer myIconWidth;
Standard_Integer myIconHeight;
Aspect_Handle myFont;
Aspect_Handle myPen;
Standard_Boolean myDragging;
Standard_Integer myStart;
Standard_Integer myIncX;
Standard_Integer myIncY;
Standard_Integer myNX;
Standard_Integer myNY;
Standard_Integer myNPos;
Standard_Integer myMaxPos;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
