// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _XmlObjMgt_HeaderFile
#define _XmlObjMgt_HeaderFile

#ifndef _XmlObjMgt_DOMString_HeaderFile
#include <XmlObjMgt_DOMString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _XmlObjMgt_Element_HeaderFile
#include <XmlObjMgt_Element.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class TCollection_ExtendedString;
class TCollection_AsciiString;
class XmlObjMgt_Persistent;
class XmlObjMgt_GP;
class XmlObjMgt_RRelocationTable;
class XmlObjMgt_Array1;
class XmlObjMgt_DataMapNodeOfRRelocationTable;
class XmlObjMgt_DataMapIteratorOfRRelocationTable;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This package defines services to manage the storage <br>
//!          grain of data produced by applications and those classes <br>
//!          to manage persistent extern reference. <br>
class XmlObjMgt  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Define the name of XMLattribute 'ID' (to be used everywhere) <br>
Standard_EXPORT static const XmlObjMgt_DOMString& IdString() ;

//! Add attribute <theElement extstring="theString" ...> <br>
Standard_EXPORT static  Standard_Boolean SetExtendedString(XmlObjMgt_Element& theElement,const TCollection_ExtendedString& theString) ;

//! Get attribute <theElement extstring="theString" ...> <br>
Standard_EXPORT static  Standard_Boolean GetExtendedString(const XmlObjMgt_Element& theElement,TCollection_ExtendedString& theString) ;

//! Returns the first child text node <br>
Standard_EXPORT static  XmlObjMgt_DOMString GetStringValue(const XmlObjMgt_Element& theElement) ;

//! Add theData as the last child text node to theElement <br>
//!          isClearText(True) avoids analysis of the string and replacement <br>
//!          of characters like '<' and '&' during XML file storage. <br>
//!          Do NEVER set isClearText unless you have a hell of a reason <br>
Standard_EXPORT static  void SetStringValue(XmlObjMgt_Element& theElement,const XmlObjMgt_DOMString& theData,const Standard_Boolean isClearText = Standard_False) ;

//! Convert XPath expression (DOMString) into TagEntry string <br>
//!          returns False on Error <br>
Standard_EXPORT static  Standard_Boolean GetTagEntryString(const XmlObjMgt_DOMString& theTarget,TCollection_AsciiString& theTagEntry) ;

//! Convert XPath expression (DOMString) into TagEntry string <br>
//!          returns False on Error <br>
Standard_EXPORT static  void SetTagEntryString(XmlObjMgt_DOMString& theSource,const TCollection_AsciiString& theTagEntry) ;


Standard_EXPORT static  XmlObjMgt_Element FindChildElement(const XmlObjMgt_Element& theSource,const Standard_Integer theObjId) ;


Standard_EXPORT static  XmlObjMgt_Element FindChildByRef(const XmlObjMgt_Element& theSource,const XmlObjMgt_DOMString& theRefName) ;


Standard_EXPORT static  XmlObjMgt_Element FindChildByName(const XmlObjMgt_Element& theSource,const XmlObjMgt_DOMString& theName) ;


Standard_EXPORT static  Standard_Boolean GetInteger(Standard_CString& theString,Standard_Integer& theValue) ;


Standard_EXPORT static  Standard_Boolean GetReal(Standard_CString& theString,Standard_Real& theValue) ;


Standard_EXPORT static  Standard_Boolean GetReal(const XmlObjMgt_DOMString& theString,Standard_Real& theValue) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class XmlObjMgt_Persistent;
friend class XmlObjMgt_GP;
friend class XmlObjMgt_RRelocationTable;
friend class XmlObjMgt_Array1;
friend class XmlObjMgt_DataMapNodeOfRRelocationTable;
friend class XmlObjMgt_DataMapIteratorOfRRelocationTable;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
