// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_BrentMinimum_HeaderFile
#define _math_BrentMinimum_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class math_Function;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! This class implements the Brent's method to find the minimum of <br>
//! a function of a single variable. <br>
//! No knowledge of the derivative is required. <br>
class math_BrentMinimum  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! This constructor should be used in a sub-class to initialize <br>
//! correctly all the fields of this class. <br>
Standard_EXPORT math_BrentMinimum(const Standard_Real TolX,const Standard_Integer NbIterations = 100,const Standard_Real ZEPS = 1.0e-12);


//! This constructor should be used in a sub-class to initialize <br>
//! correctly all the fields of this class. <br>
//! It has to be used if F(Bx) is known. <br>
Standard_EXPORT math_BrentMinimum(const Standard_Real TolX,const Standard_Real Fbx,const Standard_Integer NbIterations = 100,const Standard_Real ZEPS = 1.0e-12);


//! Given a bracketing triplet of abscissae Ax, Bx, Cx <br>
//! (such as Bx is between Ax and Cx, F(Bx) is <br>
//! less than both F(Bx) and F(Cx)) the Brent minimization is done <br>
//! on the function F. <br>
//! The tolerance required on F is given by Tolerance. <br>
//! The solution is found when : <br>
//!    abs(Xi - Xi-1) <= TolX * abs(Xi) + ZEPS; <br>
//! The maximum number of iterations allowed is given by NbIterations. <br>
Standard_EXPORT math_BrentMinimum(math_Function& F,const Standard_Real Ax,const Standard_Real Bx,const Standard_Real Cx,const Standard_Real TolX,const Standard_Integer NbIterations = 100,const Standard_Real ZEPS = 1.0e-12);


//! Brent minimization is performed on function F from a given <br>
//! bracketing triplet of abscissas Ax, Bx, Cx (such that Bx is <br>
//! between Ax and Cx, F(Bx) is less than both F(Bx) and F(Cx)) <br>
//! Warning <br>
//! The initialization constructors must have been called <br>
//! before the call to the Perform method. <br>
Standard_EXPORT   void Perform(math_Function& F,const Standard_Real Ax,const Standard_Real Bx,const Standard_Real Cx) ;


//! This method is called at the end of each iteration to check if the <br>
//! solution is found. <br>
//! It can be redefined in a sub-class to implement a specific test to <br>
//! stop the iterations. <br>
Standard_EXPORT virtual  Standard_Boolean IsSolutionReached(math_Function& F) ;
//! Returns true if the computations are successful, otherwise returns false. <br>
  Standard_Boolean IsDone() const;
//! returns the location value of the minimum. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
  Standard_Real Location() const;
//! returns the value of the minimum. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
  Standard_Real Minimum() const;
//! returns the number of iterations really done during the <br>
//! computation of the minimum. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
  Standard_Integer NbIterations() const;

//! Prints on the stream o information on the current state <br>
//!          of the object. <br>
//!          Is used to redefine the operator <<. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Standard_Real a;
Standard_Real b;
Standard_Real x;
Standard_Real fx;
Standard_Real fv;
Standard_Real fw;
Standard_Real XTol;
Standard_Real EPSZ;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean Done;
Standard_Integer iter;
Standard_Integer Itermax;
Standard_Boolean myF;


};


#include <math_BrentMinimum.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
