/* MA2CAN.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <ApproxF2var.h>
#endif 
/* Subroutine */ int mma2can_(ncfmxu, ncfmxv, ndimen, iordru, iordrv, ncoefu, 
	ncoefv, patjac, pataux, patcan, iercod)
const integer *ncfmxu, *ncfmxv, *ndimen, *iordru, *iordrv, *ncoefu, *ncoefv;
const doublereal *patjac;
doublereal *pataux, *patcan;
integer *iercod;
{
    /* System generated locals */
    integer patjac_dim1, patjac_dim2, patjac_offset, patcan_dim1, patcan_dim2,
	     patcan_offset, i__1, i__2;

    /* Local variables */
    static logical ldbg;
    static integer ilon1, ilon2, ii, nd;
    extern /* Subroutine */ int mmfmca8_();
    extern integer mnfndeb_();
    extern /* Subroutine */ int mmjacpt_(), maermsg_(), mgenmsg_(), mgsomsg_()
	    , mvriraz_();




/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*     Changement de base Jacobi vers canonique (-1,1) et ecriture dans */
/*     un tableau + grand. */

/*     MOTS CLES : */
/*     ----------- */
/*     TOUS,AB_SPECIFI,CARREAU&,CONVERSION,JACOBI,CANNONIQUE,&CARREAU */

/*     ARGUMENTS D'ENTREE : */
/*     -------------------- */
/*     NCFMXU: Dimension en U du tableau resultat PATCAN */
/*     NCFMXV: Dimension en V du tableau resultat PATCAN */
/*     NDIMEN: Dimension de l'espace de travail. */
/*     IORDRU: Ordre de contrainte en U */
/*     IORDRV: Ordre de contrainte en V. */
/*     NCOEFU: Nbre de coeff en U du carreau PATJAC */
/*     NCOEFV: Nbre de coeff en V du carreau PATJAC */
/*     PATJAC: Carreau dans la base de Jacobi d'ordre IORDRU en U et */
/*             IORDRV en V. */

/*     ARGUMENTS DE SORTIE : */
/*     --------------------- */
/*     PATAUX: Tableau auxiliaire. */
/*     PATCAN: Tableau des coefficients dans la base canonique. */
/*     IERCOD: Code d'erreur. */
/*             = 0, tout va tres bien, toutes choses etant egales par */
/*                  ailleurs. */
/*             = 1, le programme refuse de traiter avec des arguments */
/*                  d'entrees aussi stupides. */

/*     COMMONS UTILISES : */
/*     ------------------ */

/*     REFERENCES APPELEES : */
/*     --------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     29-01-1992: RBD; Ecriture version originale. */
/* > */
/* ********************************************************************** 
*/


    /* Parameter adjustments */
    patcan_dim1 = *ncfmxu;
    patcan_dim2 = *ncfmxv;
    patcan_offset = patcan_dim1 * (patcan_dim2 + 1) + 1;
    patcan -= patcan_offset;
    --pataux;
    patjac_dim1 = *ncoefu;
    patjac_dim2 = *ncoefv;
    patjac_offset = patjac_dim1 * (patjac_dim2 + 1) + 1;
    patjac -= patjac_offset;

    /* Function Body */
    ldbg = mnfndeb_() >= 2;
    if (ldbg) {
	mgenmsg_("MMA2CAN", 7L);
    }
    *iercod = 0;

    if (*iordru < -1 || *iordru > 2) {
	goto L9100;
    }
    if (*iordrv < -1 || *iordrv > 2) {
	goto L9100;
    }
    if (*ncoefu > *ncfmxu || *ncoefv > *ncfmxv) {
	goto L9100;
    }

/* -------------------- Ah les jolis changements de bases --------------- 
*/
/* ------------ (Sur l'air des 'jolies colonies de vacances') ----------- 
*/

/* --> On passe en base canonique (-1,1) */
    mmjacpt_(ndimen, ncoefu, ncoefv, iordru, iordrv, &patjac[patjac_offset], &
	    pataux[1], &patcan[patcan_offset]);

/* --> On ecrit le tout dans un tableau + grand */
    mmfmca8_(ncoefu, ncoefv, ndimen, ncfmxu, ncfmxv, ndimen, &patcan[
	    patcan_offset], &patcan[patcan_offset]);

/* --> On complete avec des zeros le tableau resultat. */
    ilon1 = *ncfmxu - *ncoefu;
    ilon2 = *ncfmxu * (*ncfmxv - *ncoefv);
    i__1 = *ndimen;
    for (nd = 1; nd <= i__1; ++nd) {
	if (ilon1 > 0) {
	    i__2 = *ncoefv;
	    for (ii = 1; ii <= i__2; ++ii) {
		mvriraz_(&ilon1, &patcan[*ncoefu + 1 + (ii + nd * patcan_dim2)
			 * patcan_dim1]);
/* L110: */
	    }
	}
	if (ilon2 > 0) {
	    mvriraz_(&ilon2, &patcan[(*ncoefv + 1 + nd * patcan_dim2) * 
		    patcan_dim1 + 1]);
	}
/* L100: */
    }

    goto L9999;

/* ---------------------- A la revoyure M'sieu dames -------------------- 
*/

L9100:
    *iercod = 1;
    goto L9999;

L9999:
    maermsg_("MMA2CAN", iercod, 7L);
    if (ldbg) {
	mgsomsg_("MMA2CAN", 7L);
    }
 return 0 ;
} /* mma2can_ */

