// File:      BinMDataStd.cxx
// Created:   30.10.02 15:16:19
// Author:    Michael SAZONOV
// Copyright: Open CASCADE 2002

#include <BinMDataStd.ixx>
#include <BinMDataStd_IntegerDriver.hxx>
#include <BinMDataStd_RealDriver.hxx>
#include <BinMDataStd_IntegerArrayDriver.hxx>
#include <BinMDataStd_RealArrayDriver.hxx>
#include <BinMDataStd_NameDriver.hxx>
#include <BinMDataStd_CommentDriver.hxx>
#include <BinMDataStd_ConstraintDriver.hxx>
#include <BinMDataStd_ExpressionDriver.hxx>
#include <BinMDataStd_GeometryDriver.hxx>
#include <BinMDataStd_PatternStdDriver.hxx>
#include <BinMDataStd_RelationDriver.hxx>
#include <BinMDataStd_TreeNodeDriver.hxx>
#include <BinMDataStd_UAttributeDriver.hxx>
#include <BinMDataStd_VariableDriver.hxx>
#include <BinMDataStd_ShapeDriver.hxx>
#include <BinMDataStd_PointDriver.hxx>
#include <BinMDataStd_AxisDriver.hxx>
#include <BinMDataStd_PlaneDriver.hxx>
#include <BinMDataStd_PlacementDriver.hxx>
#include <BinMDataStd_DirectoryDriver.hxx>
#include <BinMDataStd_NoteBookDriver.hxx>
#include <BinMDataStd_ExtStringArrayDriver.hxx>
//=======================================================================
//function : AddDrivers
//purpose  : 
//=======================================================================

void BinMDataStd::AddDrivers (const Handle(BinMDF_ADriverTable)& theDriverTable,
                              const Handle(CDM_MessageDriver)&   theMsgDriver)
{
  theDriverTable->AddDriver (new BinMDataStd_CommentDriver     (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_ConstraintDriver  (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_ExpressionDriver  (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_GeometryDriver    (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_IntegerArrayDriver(theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_IntegerDriver     (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_NameDriver        (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_PatternStdDriver  (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_RealArrayDriver   (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_RealDriver        (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_RelationDriver    (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_TreeNodeDriver    (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_UAttributeDriver  (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_VariableDriver    (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_ShapeDriver       (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_PointDriver       (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_AxisDriver        (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_PlaneDriver       (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_PlacementDriver   (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_DirectoryDriver   (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_NoteBookDriver    (theMsgDriver) );
  theDriverTable->AddDriver (new BinMDataStd_ExtStringArrayDriver(theMsgDriver) );
}
