
// File		Graphic3d_AspectText3d.cxx
// Created	Mars 1992
// Author	NW,JPB,CAL
//		30/11/98 ; FMN : S3819. Textes always visible.	 

//-Copyright	MatraDatavision 1991,1992

//-Version	

//-Design	Declaration des variables specifiques au contexte
//		de trace des textes 3d

//-Warning	Un contexte de trace de texte est defini par :
//		- la font utilisee
//		- la couleur
//		- l'echelle
//		- l'espace entre caracteres

//-References	

//-Language	C++ 2.0

//-Declarations

// for the class
#include <Graphic3d_AspectText3d.ixx>

#include <TCollection_AsciiString.hxx>
#include <OSD_Environment.hxx>

//-Aliases

//-Global data definitions

//	-- la font utilisee
//	MyFont		:	NameOfFont;

//	-- la couleur
//	MyColor		:	Color;

//	-- l'echelle
//	MyFactor	:	Standard_Real;

//	-- l'espace entre caracteres
//	MySpace		:	Standard_Real;

//	-- le style
//	MyStyle		:	TypeOfStyleText;

//	-- le display type
//	MyDisplayType	:	TypeOfDisplayText;

//	-- la couleur du sous-titrage et pour le fond en mode decalage.
//	MyColorSubTitle	:	Color;

//-Constructors

//-Destructors

//-Methods, in order

#define OCC2934 //SAN 22/01/04 Texture mapped fonts on WNT 

#if defined(OCC2934) && defined(WNT)
// OCC6571
// enableTexFont ==  0: not initialized
//                  -1: texture mapped fonts off by default in Graphic3d_AspectText3d constructor
//                   1: texture mapped fonts on  by default in Graphic3d_AspectText3d constructor
static Standard_Integer enableTexFont = 0; 
#endif

void Graphic3d_AspectText3d::TexFontEnable() {
#if defined(OCC2934) && defined(WNT)
  enableTexFont = 1;
#endif
}

void Graphic3d_AspectText3d::TexFontDisable() {
#if defined(OCC2934) && defined(WNT)
  enableTexFont = -1;
#endif
}

Standard_Boolean Graphic3d_AspectText3d::IsTexFontEnable()
{
#if defined(OCC2934) && defined(WNT)
  if (enableTexFont == 0) {
    enableTexFont = 1; //OCC6571 Bitmap or Textured mapped fonts mode must be defined by program way through API.
    OSD_Environment csf(TCollection_AsciiString("CSF_TEX_FONT"));
    TCollection_AsciiString value = csf.Value();
    if (value.Length() > 0 && value.IsIntegerValue()) {
      enableTexFont = value.IntegerValue();
      if (enableTexFont <= 0)
        enableTexFont = -1;
      else if (enableTexFont > 1)
        enableTexFont = 1;
    }
  }
  if( enableTexFont > 0 ) return Standard_True;
#endif
  return Standard_False;
}

Graphic3d_AspectText3d::Graphic3d_AspectText3d ():
MyFont (Graphic3d_NOF_ASCII_MONO), MyColor (Quantity_NOC_YELLOW), MyFactor (1.0), MySpace (0.0), MyStyle (Aspect_TOST_NORMAL), MyDisplayType (Aspect_TODT_NORMAL), MyColorSubTitle (Quantity_NOC_WHITE) {
#if defined(OCC2934) && defined(WNT)
    MyTextureMappedFont = IsTexFontEnable();
#endif
}

Graphic3d_AspectText3d::Graphic3d_AspectText3d (
	const Quantity_Color& AColor, 
	const Graphic3d_NameOfFont AFont, 
	const Standard_Real AFactor, 
	const Standard_Real ASpace,
	const Aspect_TypeOfStyleText AStyle,
	const Aspect_TypeOfDisplayText ADisplayType):
MyFont (AFont), MyColor (AColor), MyFactor (AFactor), MySpace (ASpace), MyStyle (AStyle), MyDisplayType(ADisplayType), MyColorSubTitle (Quantity_NOC_WHITE) {
#if defined(OCC2934) && defined(WNT)
    MyTextureMappedFont = IsTexFontEnable();
#endif
	if (AFactor <= 0.0)
		Graphic3d_AspectTextDefinitionError::Raise
			("Bad value for TextScaleFactor");

}

void Graphic3d_AspectText3d::SetColor (const Quantity_Color& AColor) {

	MyColor		= AColor;

}

void Graphic3d_AspectText3d::SetExpansionFactor (const Standard_Real AFactor) {

	if (AFactor <= 0.0)
		Graphic3d_AspectTextDefinitionError::Raise
			("Bad value for TextScaleFactor");

	MyFactor	= AFactor;

}

void Graphic3d_AspectText3d::SetFont (const Graphic3d_NameOfFont AFont) {

	MyFont		= AFont;

}

void Graphic3d_AspectText3d::SetSpace (const Standard_Real ASpace) {

	MySpace		= ASpace;

}

void Graphic3d_AspectText3d::SetStyle(const Aspect_TypeOfStyleText AStyle) {

	MyStyle		= AStyle;
}

void Graphic3d_AspectText3d::SetDisplayType(const Aspect_TypeOfDisplayText ADisplayType) {

	MyDisplayType	= ADisplayType;
}

void Graphic3d_AspectText3d::SetColorSubTitle (const Quantity_Color& AColor) {

	MyColorSubTitle	= AColor;

}

void Graphic3d_AspectText3d::SetTextureMappedFont(const Standard_Boolean 
#if defined(OCC2934) && defined(WNT)
                                                  AFlag
#endif
                                                  ) {
#if defined(OCC2934) && defined(WNT)
    MyTextureMappedFont = AFlag;
#endif
}

void Graphic3d_AspectText3d::Values (Quantity_Color& AColor, Graphic3d_NameOfFont& AFont, Standard_Real& AFactor, Standard_Real& ASpace) const {

	AColor		= MyColor;
	AFont		= MyFont;
	AFactor		= MyFactor;
	ASpace		= MySpace;

}
void Graphic3d_AspectText3d::Values (Quantity_Color& AColor, Graphic3d_NameOfFont& AFont, Standard_Real& AFactor, Standard_Real& ASpace, Aspect_TypeOfStyleText& AStyle,Aspect_TypeOfDisplayText& ADisplayType,Quantity_Color& AColorSubTitle, Standard_Boolean& ATextureMappedFont) const {

	AColor		= MyColor;
	AFont		= MyFont;
	AFactor		= MyFactor;
	ASpace		= MySpace;
	AStyle		= MyStyle;
	ADisplayType	= MyDisplayType;
	AColorSubTitle	= MyColorSubTitle;
#if defined(OCC2934) && defined(WNT)
          ATextureMappedFont = MyTextureMappedFont;
#else
          ATextureMappedFont = Standard_False;
#endif
}
