#include <MDataStd_ConstraintRetrievalDriver.ixx>
#include <MDataStd.hxx>
#include <PDataStd_Constraint.hxx>
#include <TDataStd_Constraint.hxx>
#include <TDataStd_ConstraintEnum.hxx>
#include <TNaming_NamedShape.hxx>
#include <PNaming_NamedShape.hxx>
#include <PDF_HAttributeArray1.hxx>
#include <Standard_NoSuchObject.hxx>
#include <Standard_DomainError.hxx>
#include <CDM_MessageDriver.hxx>


//=======================================================================
//function : MDataStd_ConstraintRetrievalDriver
//purpose  : 
//=======================================================================

MDataStd_ConstraintRetrievalDriver::MDataStd_ConstraintRetrievalDriver(const Handle(CDM_MessageDriver)& theMsgDriver):MDF_ARDriver(theMsgDriver)
{
}

//=======================================================================
//function : VersionNumber
//purpose  : 
//=======================================================================

Standard_Integer MDataStd_ConstraintRetrievalDriver::VersionNumber() const
{ return 0; }


//=======================================================================
//function : SourceType
//purpose  : 
//=======================================================================

Handle(Standard_Type) MDataStd_ConstraintRetrievalDriver::SourceType() const
{ return STANDARD_TYPE(PDataStd_Constraint);  }




//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================

Handle(TDF_Attribute) MDataStd_ConstraintRetrievalDriver::NewEmpty() const
{ return new TDataStd_Constraint (); }



//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================

void MDataStd_ConstraintRetrievalDriver::Paste (
  const Handle(PDF_Attribute)&        Source,
  const Handle(TDF_Attribute)&        Target,
  const Handle(MDF_RRelocationTable)& RelocTable) const
{
  Handle(PDataStd_Constraint) S = 
     Handle(PDataStd_Constraint)::DownCast (Source);
  Handle(TDataStd_Constraint) T = 
    Handle(TDataStd_Constraint)::DownCast (Target);

  Handle(TDataStd_Real) TValue;
  Handle(PDataStd_Real) Value = S->GetValue ();
  if (!Value.IsNull ()) {
    if (!RelocTable->HasRelocation(Value, TValue )) {
      Standard_NoSuchObject::Raise("MDataStd_ConstraintRetrievalDriver::Paste");
    }
    T->SetValue(TValue);
  }
  
  Handle(PDF_HAttributeArray1) PGeometries = S->GetGeometries ();
  if (!PGeometries.IsNull()) {
    for (Standard_Integer i = 1; i <= PGeometries->Length (); i++) {
      Handle(PDF_Attribute) PG = PGeometries->Value (i);
      if (!PG.IsNull ()) {
	Handle(TNaming_NamedShape) G;
	if (!RelocTable->HasRelocation (PG, G)) {
	  Standard_NoSuchObject::Raise("MDataStd_ConstraintRetrievalDriver::Paste");
	}
	T->SetGeometry (i, G);
      }
    }
  }


  Handle(PNaming_NamedShape) PPlane = S->GetPlane();
  Handle(TNaming_NamedShape) TPlane;
  if (!PPlane.IsNull()) {
    if (!RelocTable->HasRelocation (PPlane, TPlane )) {
      Standard_NoSuchObject::Raise("MDataStd_ConstraintStorageDriver::Paste");
    }
    T->SetPlane(TPlane);
  }
  T->SetType (MDataStd::IntegerToConstraintType (S->GetType ()));
  T->Verified(S->Verified());
  T->Inverted(S->Inverted());
  T->Reversed(S->Reversed());
}



